var serverSystem = server.registerSystem(0, 0);

// Setup which events to listen for
serverSystem.initialize = function () {
  this.initLogger()
  this.listenForEvent('minecraft:block_interacted_with', (eventData) => {
    const player = eventData.data.player
    const location = eventData.data.block_position

    const tickWorldComponent = this.getComponent(player, 'minecraft:tick_world')
    const tickingArea = tickWorldComponent.data.ticking_area

    const block = this.getBlock(tickingArea, location)

    if (this.hasComponent(block, 'minecraft:blockstate')) {
      const blockstate = this.getComponent(block, 'minecraft:blockstate')
      if (block.__identifier__ === 'minecraft:snow_layer') {
        this.chat(`before: block: ${block.__identifier__}, blockstate: ${JSON.stringify(blockstate.data)}`)

        if (blockstate.data['height'] < 5) blockstate.data['height']++
        else blockstate.data['height'] = 0

        this.applyComponentChanges(block, blockstate)

        this.chat(`after: blockstate: ${JSON.stringify(blockstate.data)}`)
      }
    }
  })
}

serverSystem.chat = function (message) {
  let event = this.createEventData('minecraft:display_chat_event')
  event.data.message = message
  this.broadcastEvent('minecraft:display_chat_event', event)
}

serverSystem.initLogger = function () {
  const scriptLoggerConfig = this.createEventData('minecraft:script_logger_config')
  scriptLoggerConfig.data.log_errors = true
  scriptLoggerConfig.data.log_information = true
  scriptLoggerConfig.data.log_warnings = true
  this.broadcastEvent('minecraft:script_logger_config', scriptLoggerConfig)
}


// per-tick updates
serverSystem.update = function () {
	// Any logic that needs to happen every tick on the server.
}
