#version 150

uniform sampler2D InSampler;
uniform sampler2D InDepthSampler;

in vec2 texCoord;

out vec4 fragColor;

float linearizeDepthFast(float depth, float near, float far) {
    return (near * far) / (depth * (near - far) + far);
}

void main(){
    vec4 diffuseColor = texture(InSampler, texCoord);
    fragColor = vec4(diffuseColor.rgb, 1.0);
    float depth = texture(InDepthSampler, texCoord).r;
    if (texCoord.x > -10.0) {
        fragColor.rgb = vec3(linearizeDepthFast(depth, 0.05, 100.0)) / 100.0;
    }
}
