import { world } from "@minecraft/server";
const advancements = [
    {
        name: "%bob.achievement.3",
        item: "minecraft:stone_pickaxe",
        requiredAmount: 1,
        tag: "stone_pickaxe",
        title: "bob.toast;achievement.3",
        epic: false,
    },
    {
        name: "%bob.achievement.5",
        item: "minecraft:iron_ingot",
        requiredAmount: 1,
        tag: "iron_ingot",
        title: "bob.toast;achievement.5",
        epic: false,
    },
    {
        name: "%bob.achievement.6",
        item: "minecraft:lava_bucket",
        requiredAmount: 1,
        tag: "lava_bucket",
        title: "bob.toast;achievement.6",
        epic: false,
    },
    {
        name: "%bob.achievement.7",
        item: "minecraft:iron_chestplate",
        requiredAmount: 1,
        tag: "iron_chestplate",
        title: "bob.toast;achievement.7",
        epic: false,
    },
    {
        name: "%bob.achievement.8",
        item: "minecraft:iron_pickaxe",
        requiredAmount: 1,
        tag: "iron_pickaxe",
        title: "bob.toast;achievement.8",
        epic: false,
    },
    {
        name: "%bob.achievement.9",
        item: "minecraft:obsidian",
        requiredAmount: 1,
        tag: "obsidian",
        title: "bob.toast;achievement.9",
        epic: false,
    },
    {
        name: "%bob.achievement.10",
        item: "minecraft:diamond",
        requiredAmount: 1,
        tag: "diamond",
        title: "bob.toast;achievement.10",
        epic: false,
    },
    {
        name: "%bob.achievement.11",
        item: "minecraft:diamond_chestplate",
        requiredAmount: 1,
        tag: "diamond_chestplate",
        title: "bob.toast;achievement.11",
        epic: false,
    },
    {
        name: "%bob.achievement.12",
        item: "minecraft:enchanted_book",
        requiredAmount: 1,
        tag: "enchanted_book",
        title: "bob.toast;achievement.12",
        epic: false,
    },
    {
        name: "%bob.achievement.13",
        item: "minecraft:golden_apple",
        requiredAmount: 1,
        tag: "golden_apple",
        title: "bob.toast;achievement.13",
        epic: false,
    },
    {
        name: "%bob.achievement.14",
        item: "minecraft:ender_eye",
        requiredAmount: 1,
        tag: "ender_eye",
        title: "bob.toast;achievement.14",
        epic: true,
    },

    {
        name: "%bob.achievement.15",
        item: "minecraft:honey_bottle",
        requiredAmount: 1,
        tag: "honey_bottle",
        title: "bob.toast;achievement.15",
        epic: false,
    },
    {
        name: "%bob.achievement.16",
        item: "minecraft:lead",
        requiredAmount: 1,
        tag: "lead",
        title: "bob.toast;achievement.16",
        epic: false,
    },


    {
        name: "%bob.achievement.17",
        item: "better_on_bedrock:wild_carrot",
        requiredAmount: 1,
        tag: "wild_carrot",
        title: "bob.toast;achievement.17",
        epic: true,
    },
    {
        name: "%bob.achievement.18",
        item: "better_on_bedrock:coconut_nut",
        requiredAmount: 1,
        tag: "coconut_nut",
        title: "bob.toast;achievement.18",
        epic: false,
    },
    {
        name: "%bob.achievement.19",
        item: "better_on_bedrock:ender_tear",
        requiredAmount: 1,
        tag: "ender_tear",
        title: "bob.toast;achievement.19",
        epic: true,
    },
    {
        name: "%bob.achievement.20",
        item: "better_on_bedrock:waystone_block",
        requiredAmount: 1,
        tag: "waystone",
        title: "bob.toast;achievement.20",
        epic: false,
    },
];

/** @param { import("@minecraft/server").Player } player */
export function getItems(player) {
    const inventory = player.getComponent("inventory").container;
    for (let slot = 0; slot < inventory.size; slot++) {
        const itemStack = inventory.getItem(slot);
        if (itemStack === undefined)
            continue;

        const advancement = advancements.find(
            (a) =>
                itemStack.typeId == a.item
                && itemStack.amount >= a.requiredAmount
                && !player.hasTag(a.tag)
        );

        if (advancement == undefined)
            continue;

        world.sendMessage([
            { text: "§a[!] §7" },
            {
                translate: "bob.message.achievementMade",
                with: [
                    player.name,
                    (advancement.epic ? "§u" : "§e") + advancement.name
                ],
            }
        ]);

        player.playSound(advancement.epic ? "epic_quest" : "normal_quest");
        player.addTag(advancement.tag);
        player.sendMessage(advancement.title);
    };
};