import { world, ItemStack, EquipmentSlot, EntityEquippableComponent } from '@minecraft/server';
const slabs = [
    { id: "better_on_bedrock:chorus_slab" },
    { id: "better_on_bedrock:dusk_slab" },
    { id: "better_on_bedrock:malbite_bricks_slab" },
    { id: "better_on_bedrock:malbite_smooth_slab" },
    { id: "better_on_bedrock:malbite_smoother_slab" },
    { id: "better_on_bedrock:voiding_slab" },
    { id: "better_on_bedrock:andesite_brick_slab" },
    { id: "better_on_bedrock:basalt_bricks_slab" },
    { id: "better_on_bedrock:chissled_basalt_bricks_slab" },
    { id: "better_on_bedrock:polished_basalt_slab" },
    { id: "better_on_bedrock:calcite_brick_slab" },
    { id: "better_on_bedrock:diorite_brick_slab" },
    { id: "better_on_bedrock:dripstone_brick_slab" },
    { id: "better_on_bedrock:granite_brick_slab" },
    { id: "better_on_bedrock:cobbled_sandstone_slab" },
    { id: "better_on_bedrock:sandstone_bricks_slab" },
    { id: "better_on_bedrock:smooth_sandstone_bricks_slab" },
    { id: "better_on_bedrock:smooth_sandstone_bricks_slab" },
    { id: "better_on_bedrock:soulsand_bricks_slab" },
    { id: "better_on_bedrock:cobbled_red_sandstone_slab" },
    { id: "better_on_bedrock:red_sandstone_bricks_slab" },
];

/** @type { import("@minecraft/server").BlockCustomComponent } */
export const events = {
    onPlayerDestroy: ({
        block,
        destroyedBlockPermutation: permutation,
        player
    }) => {
        const equippable = player.getComponent(EntityEquippableComponent.componentId);
        const selectedItem = equippable.getEquipment(EquipmentSlot.Mainhand);

        const isPickaxe = selectedItem.hasTag("minecraft:is_pickaxe");
        if (!isPickaxe)
            return;

        
        player.dimension.spawnItem(new ItemStack(permutation.type.id), block.location);
    },
};