import { world } from "@minecraft/server";

import { configScreen } from "../../functionality/items/addon-config";
import { lostJournal } from "../../functionality/items/lost-journal";
import { lootbags } from "../../functionality/items/lootbags";
import { netherAmulet } from "../../functionality/items/nether-amulet";
import { useStaff } from "../../functionality/items/staffs";

world.afterEvents.itemUse.subscribe(
    ({ itemStack, source }) => {
        configScreen(itemStack, source);
        if (itemStack.typeId == "better_on_bedrock:lost_journal")
            lostJournal(source);
        lootbags(itemStack, source);
        netherAmulet(itemStack, source);
        useStaff(itemStack, source);
        if(itemStack.typeId=='better_on_bedrock:flender_staff') {
            source.dimension.playSound(`staff.flender.use`, source.getHeadLocation())
        }
        if(itemStack.typeId=='better_on_bedrock:ice_staff') {
            source.dimension.playSound(`staff.ice.use`, source.getHeadLocation())
        }
        if(itemStack.typeId=='better_on_bedrock:flame_staff' && source.isSneaking) {
            source.dimension.playSound(`staff.fire.use`, source.getHeadLocation())
        }
    },
);