import { world, system, GameMode } from "@minecraft/server"
const range = 25; // Adjust this value to define the desired search area
const chunkSize = 7; // Adjust this value to control the number of blocks checked per iteration

function searchCube(player) {
    for (let xStart = -range; xStart <= range; xStart += chunkSize) {
        for (let yStart = -range; yStart <= range; yStart += chunkSize) {
            for (let zStart = -range; zStart <= range; zStart += chunkSize) {
                for (let i = 0; i < chunkSize; i++) {
                    if (Math.random() > 0.7) {
                        const randomXOffset = Math.floor(Math.random() * chunkSize);
                        const randomYOffset = Math.floor(Math.random() * chunkSize);
                        const randomZOffset = Math.floor(Math.random() * chunkSize);

                        const blockX = player.location.x + xStart + randomXOffset;
                        const blockY = player.location.y + yStart + randomYOffset + 16;
                        const blockZ = player.location.z + zStart + randomZOffset;

                        try {
                            if (player.hasTag("fallenLeaves")) {
                                const block = player.dimension.getBlock({ x: blockX, y: blockY, z: blockZ });
                                let particle;
                                switch (block.typeId) {
                                    case "minecraft:oak_leaves": particle = "pog:oak_leaf"; break;
                                    case "minecraft:dark_oak_leaves": particle = "pog:oak_leaf"; break;
                                    case "minecraft:acacia_leaves": particle = "pog:oak_leaf"; break;
                                    case "minecraft:spruce_leaves": particle = "pog:spruce_leaf"; break;
                                    case "minecraft:jungle_leaves": particle = "pog:jungle_leaf"; break;
                                    case "minecraft:birch_leaves": particle = "pog:birch_leaf"; break;
                                    case "minecraft:azalea_leaves": particle = "pog:azalea_leaf"; break;
                                    default: continue;
                                };

                                player.dimension.spawnParticle(particle, block.location);
                            };
                        } catch { };
                    };
                };
            };
        };
    };
};

system.runInterval(() => {
    const players = world.getAllPlayers();
    for (let i = 0; i < players.length; i++) {
        const player = players[i];
        switch (player.dimension.id) {
            case "minecraft:overworld": {
                player.removeTag("overworld");

                if (player.hasTag("fallenLeaves")) {
                    searchCube(player);
                };
                break;
            };
        };
    };
}, 30);

/*system.runInterval(() => {
    const players = world.getAllPlayers();
    for (let i = 0; i < players.length; i++) {
        const player = players[i];
        switch (player.dimension.id) {
            case "minecraft:overworld": {
                if (player.hasTag("fallenLeaves")) {
                    player.dimension.spawnParticle('pog:oak_leaf_detector', player.location);
                    player.dimension.spawnParticle('pog:birch_leaf_detector', player.location);
                    player.dimension.spawnParticle('pog::spruce_leaf_detector', player.location);
                    player.dimension.spawnParticle('pog:jungle_leaf_detector', player.location);
                };
                break;
            };
        };
    };
}, 40);*/


system.runInterval(() => {
    const players = world.getAllPlayers();
    for (let i = 0; i < players.length; i++) {
        const player = players[i];
        switch (player.dimension.id) {
            case "minecraft:overworld": {
                if (player.hasTag("cave"))
                    player.playSound("ambient.cave_random");
                break;
            };
            case "minecraft:the_end": {
                player.playSound("ambient.random.end");
                break;
            };
        };
    };
}, Math.random() * (880 - 480) + 480);


system.runInterval(() => {
    const players = world.getAllPlayers();
    for (let i = 0; i < players.length; i++) {
        const player = players[i];

        switch (player.dimension.id) {
            case "minecraft:the_end":
            case "minecraft:nether": {
                if (player.hasTag("overworld"))
                    continue;

                player.addTag("overworld");
                player.removeTag("night");
                player.removeTag("swamps");
                player.removeTag("swamp");
                player.removeTag("taigas");
                player.removeTag("taiga");
                player.removeTag("jungles");
                player.removeTag("jungle");
                player.removeTag("plain");
                player.removeTag("plains");
                break;
            };
            case "minecraft:overworld": {
                function underwaterAmbience() {
                    if (player.location.y + 1 > player.dimension.heightRange.max
                        || player.location.y < player.dimension.heightRange.min)
                        return false;

                    const headBlock = player.dimension.getBlock({
                        x: player.location.x,
                        y: player.location.y + 1,
                        z: player.location.z,
                    });
                    if (headBlock?.typeId?.includes("water")) {
                        if (player.hasTag("underwater"))
                            return true;



                        player.addTag("underwater");
                        player.playMusic("ambient.underwater.loop", {
                            volume: 1,
                            loop: true,
                            fade: 1
                        });
                        return;
                    }
                    else if (player.hasTag("underwater")) {
                        player.removeTag("underwater");
                        player.stopMusic();
                    };

                    return false;
                };
            };
        };
    };
}, 20);