import { world, system, BlockTypes, EntityInventoryComponent, ItemStack } from "@minecraft/server";
export const blocks = BlockTypes.getAll().map((block) => block.id);

import { wawla } from "./functionality/wawla.js";
import { ghostNecklace } from "./functionality/items/ghost-necklace.js";
import { voidTotem } from "./functionality/items/void-totem.js";
import { voidBoots } from "./functionality/items/void-boots.js";

import { poggy } from "./functionality/entities/poggy.js";
import { seeker } from "./functionality/entities/seeker.js";
import { sootEye } from "./functionality/entities/soot_eye.js";

import * as Achievements from "./functionality/advancements/index.js"
import { registerBlockComponents, registerItemComponents } from "./custom_components/index.js";

import "./scripting_events/index.js";
import "./functionality/index.js";
import "./functionality/entities/inferior.js";
import "./functionality/custom_spear/handler.js";

import "./functionality/entities/seeker.js";
import "./functionality/entities/seeker_teleport.js";

import "./functionality/blocks/jukebox.js";
import "./functionality/blocks/strip_block.js";

// Imports our custom components
import { wall_Manager } from './custom_components/blocks/walls/wall_Manager.js'

world.afterEvents.playerBreakBlock.subscribe((data) => {
    wall_Manager.updateWallsAround(data.block)
})

world.afterEvents.playerPlaceBlock.subscribe((data) => {
    wall_Manager.updateWallsAround(data.block)
})


/** @param { import("@minecraft/server").Vector3 } vector */
function vectorLength(vector) {
    const x = Math.pow(vector.x, 2);
    const y = Math.pow(vector.y, 2);
    const z = Math.pow(vector.z, 2);
    return Math.sqrt(x + y + z);
};

// Main interval
system.runInterval(() => {
    system.runJob(function *() {
        const players = world.getAllPlayers();
        for (let i = 0; i < players.length; i++) {
            const player = players[i];
            Achievements.getItems(player);
            yield;

            // First time moving
            const velocityVector = player.getVelocity();
            const velocity = vectorLength({ x: velocityVector.x, y: 0, z: velocityVector.z });
            if (velocity > 0 && !player.hasTag("introMove")) {
                player.addTag("introMove");

                player.sendMessage([
                    { text: "§6[!] §r" },
                    { translate: "bob.message.welcome" },
                ]);
                player.sendMessage("bob.toast;achievement.0");
                player.playSound("normal_quest");

                const container = player.getComponent(EntityInventoryComponent.componentId).container;
                container.addItem(new ItemStack("better_on_bedrock:lost_journal"));
                container.addItem(new ItemStack("better_on_bedrock:quest_paper"));
            };

            ghostNecklace(player);
            voidTotem(player);
            voidBoots(player);

            // Boss attacks
            poggy(player);
            seeker(player);
            sootEye(player);
            yield;
        };
    }());
}, 2);

system.runInterval(() => {
    const players = world.getAllPlayers();
    for (let i = 0; i < players.length; i++) {
        const player = players[i];
        if (player.hasTag("toolTip"))
            wawla(player);
    };
});

// Custom Components
world.beforeEvents.worldInitialize.subscribe(
    ({ blockComponentRegistry, itemComponentRegistry }) => {
        registerBlockComponents(blockComponentRegistry);
        registerItemComponents(itemComponentRegistry);
    },
);
