import { mine } from "./functionality";

/** @param { import("@minecraft/server").PlayerBreakBlockAfterEvent } data */
export function treeCapitator({
    block, player, dimension,
    itemStackBeforeBreak: itemStack,
    itemStackAfterBreak: afterItemStack,
    brokenBlockPermutation: permutation,
}) {
    if (itemStack == undefined || !itemStack.getLore().includes("§r§7Tree Capitator I") || player.isSneaking)
        return;

    if (!permutation.hasTag("log"))
        return;

    const blockType = permutation.type.id;
    const blocks = [
        {
            blocks: [
                {
                    name: blockType,
                    mineable: [],
                    drop: blockType,
                }
            ]
        }
    ];

    mine(block, blockType, player, itemStack, blocks);
};