import { world } from "@minecraft/server";

/**
 * @param { import("@minecraft/server").Block } block
 * @param { import("@minecraft/server").Dimension } dimension
 * @param { import("@minecraft/server").Player } player
 */
export function blockPlace(block, dimension, player) {
    let achievementName;
    switch (block.typeId) {
        case "better_on_bedrock:enchant_bench":
            if (player.hasTag("firts_block")) return;

            achievementName = "§a%bob.achievement.21";
            player.playSound("normal_quest");
            player.addTag("firts_block");
            player.sendMessage("bob.toast;achievement.21");
        break;
        case "minecraft:carrots":
            if (player.hasTag("carrots")) return;

            achievementName = "§a%bob.achievement.4";
            player.playSound("normal_quest");
            player.addTag("carrots");
            player.sendMessage("bob.toast;achievement.4");
        break;
        case "minecraft:crafting_table":
            if (player.hasTag("craftingTable")) return;

            achievementName = "§a%bob.achievement.1";
            player.playSound("normal_quest");
            player.addTag("craftingTable");
            player.sendMessage("bob.toast;achievement.1");
        break;
        default: return;
    };

    world.sendMessage([
        { text: "§a[!] §7" },
        {
            translate: "bob.message.achievementMade",
            with: [
                player.name,
                achievementName
            ],
        },
    ]);
};