import { world } from "@minecraft/server";

/** @param { import("@minecraft/server").PlayerBreakBlockAfterEvent } data */
export function blockBreak({
    block, brokenBlockPermutation: permutation,
    player
}) {
    let achievementName;
    switch (permutation.type.id) {
        case "minecraft:stone":
            if (player.hasTag("stone_age")) return;

            achievementName = "§e%bob.achievement.2";
            player.playSound("normal_quest");
            player.addTag("stone_age");
            player.sendMessage("bob.toast;achievement.2");
        break;
        case "better_on_bedrock:stardust_ore":
            if (player.hasTag("stardust_ore")) return;

            achievementName = "§u%bob.achievement.22";
            player.playSound("epic_quest");
            player.addTag("stardust_ore");
            player.sendMessage("bob.toast;achievement.22");
        break;
        default: return;
    };

    world.sendMessage([
        { text: "§a[!] §7" },
        {
            translate: "bob.message.achievementMade",
            with: [
                player.name,
                achievementName
            ],
        },
    ]);
};