import * as GameTest from "GameTest";
import { BlockLocation, BlockTypes, Commands } from "Minecraft";

const TicksPerSecond = 20;
const FiveSecondsInTicks = 5 * TicksPerSecond;

GameTest.register("CommandTests", "fill_command", (test) => {
    // const entity = test.spawn("minecraft:armor_stand", new BlockLocation(0, 2, 0))
    test.startSequence()
        .thenExecute(() => test.setBlockType(BlockTypes.concrete, new BlockLocation(1, 2, 1)))
        .thenExecuteAfter(5, () => Commands.run("/execute @e[type=armor_stand,name=\"Fill - Replace - Command\",c=1] ~ ~ ~ fill ~1 ~ ~1 ~1 ~ ~1 concretepowder [\"color\":\"blue\"] replace concrete [\"color\":\"blue\"]"))
        .thenWait(() => {
            test.succeedWhen(() => {
                test.assertBlockTypePresent(BlockTypes.concrete, new BlockLocation(1, 2, 1));
            });
        });

})
    .maxTicks(FiveSecondsInTicks)
    .structureName("CommandTests:fill_command")
    .maxAttempts(1);;