import * as GameTest from "mojang-gametest";
import {BlockLocation} from "mojang-minecraft";

GameTest.registerAsync("new_execute_command_tests", "mcpe_156283", async (test) => {
	const Origin = test.worldBlockLocation(new BlockLocation(0, 2, 1))
	test.spawnSimulatedPlayer(new BlockLocation(3, 2, 1), "TargetPos");
	test.spawn("armor_stand", new BlockLocation(2, 2, 1));

	await test.idle(20);
	await test.getDimension().runCommandAsync(`execute positioned ${Origin.x} ${Origin.y} ${Origin.z} at "TargetPos" as @e[type=armor_stand,r=1.5] run say Found!`)
	test.succeed();
})
	.structureName("command_tests:execute_at_mixed_arguments");