//Thanks for the much help with this gametest @Frost! (this gametest is owned by ID)
import {
    world
} from 'mojang-minecraft';

world.events.tick.subscribe(onGameTick);
function getInv(target) {
    let container = target.getComponent('inventory')?.container;
    if (!container)
        return [];
    return new Array(container.size).fill(undefined).map((v, i) => container.getItem(i));
}


function hit_marker() {
    world.events.entityHit.subscribe((ev) => {
        if (ev.entity.id == 'minecraft:player') {world.getDimension('overworld').runCommand(`title "${ev.entity.nameTag}" title x.hit_marker.hud`)};
    });
}


function small_energycell() {
    [...world.getPlayers()].forEach(plr => {
        let c = 0;
        getInv(plr).filter(v => v?.id == 'sw:small_energycell').forEach(v => c += v.amount);
        world.getDimension('overworld').runCommand(`scoreboard players set "${plr.nameTag}" small_energycell ${c}`);
    });
}

function rps6_rocket() {
    [...world.getPlayers()].forEach(plr => {
        let c = 0;
        getInv(plr).filter(v => v?.id == 'sw:rps6_rocket').forEach(v => c += v.amount);
        world.getDimension('overworld').runCommand(`scoreboard players set "${plr.nameTag}" rps6_rocket ${c}`);
    });
}

function large_energycell() {
    [...world.getPlayers()].forEach(plr => {
        let c = 0;
        getInv(plr).filter(v => v?.id == 'sw:large_energycell').forEach(v => c += v.amount);
        world.getDimension('overworld').runCommand(`scoreboard players set "${plr.nameTag}" large_energycell ${c}`);
    });
}

function energycell() {
    [...world.getPlayers()].forEach(plr => {
        let c = 0;
        getInv(plr).filter(v => v?.id == 'sw:energycell').forEach(v => c += v.amount);
        world.getDimension('overworld').runCommand(`scoreboard players set "${plr.nameTag}" energycell ${c}`);
    });
}

function onGameTick() {
    try {
        hit_marker();
    } catch(e) {
        console.warn(e)}
    try {
        small_energycell();
    } catch(e) {
        console.warn(e)}
    try {
        large_energycell();
    } catch(e) {
        console.warn(e)}
    try {
        rps6_rocket();
    } catch(e) {
        console.warn(e)}
    try {
        energycell();
    } catch(e) {
        console.warn(e)}
}