#include "ShaderConstants.fxh"
#include "util.fxh"

struct PS_Input
{
	float3 chunkPos : POSITION;
	float4 position : SV_Position;

#ifndef BYPASS_PIXEL_SHADER
	lpfloat4 color : COLOR;
	snorm float2 uv0 : TEXCOORD_0_FB_MSAA;
	snorm float2 uv1 : TEXCOORD_1_FB_MSAA;
#endif

#ifdef FOG
	float4 fogColor : FOG_COLOR;
#endif
};

struct PS_Output
{
	float4 color : SV_Target;
};

ROOT_SIGNATURE
void main(in PS_Input PSInput, out PS_Output PSOutput)
{
#ifdef BYPASS_PIXEL_SHADER
    PSOutput.color = float4(0.0f, 0.0f, 0.0f, 0.0f);
    return;
#else

#if USE_TEXEL_AA
	float4 diffuse = texture2D_AA(TEXTURE_0, TextureSampler0, PSInput.uv0 );
#else
	float4 diffuse = TEXTURE_0.Sample(TextureSampler0, PSInput.uv0);
#endif

#ifdef SEASONS_FAR
	diffuse.a = 1.0f;
#endif

#if USE_ALPHA_TEST
	#ifdef ALPHA_TO_COVERAGE
		#define ALPHA_THRESHOLD 0.05
	#else
		#define ALPHA_THRESHOLD 0.5
	#endif
	if(diffuse.a < ALPHA_THRESHOLD)
		discard;
#endif

#if defined(BLEND)
	diffuse.a *= PSInput.color.a;
#endif

#if !defined(ALWAYS_LIT)
	diffuse = diffuse * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
#endif

#ifndef SEASONS
	#if !USE_ALPHA_TEST && !defined(BLEND)
		diffuse.a = PSInput.color.a;
	#endif	
	diffuse.rgb *= PSInput.color.rgb;

#else
	float2 uv = PSInput.color.xy;
	diffuse.rgb *= lerp(1.0f, TEXTURE_2.Sample(TextureSampler2, uv).rgb*2.0f, PSInput.color.b);
	diffuse.rgb *= PSInput.color.aaa;
	diffuse.a = 1.0f;
#endif


	float3 cp = frac(PSInput.chunkPos.xyz);
	if
	(
			((PSInput.chunkPos.x < 0.0625 || PSInput.chunkPos.x > 15.9375) && (PSInput.chunkPos.y < 0.0625 || PSInput.chunkPos.y > 15.9375)) ||
			((PSInput.chunkPos.x < 0.0625 || PSInput.chunkPos.x > 15.9375) && (PSInput.chunkPos.z < 0.0625 || PSInput.chunkPos.z > 15.9375)) ||
			((PSInput.chunkPos.y < 0.0625 || PSInput.chunkPos.y > 15.9375) && (PSInput.chunkPos.z < 0.0625 || PSInput.chunkPos.z > 15.9375))
	)
		diffuse.rgb =lerp(diffuse.rgb,float3(0.0f, 0.0f, 1.0f),0.2f);
else
	if
	(
		((PSInput.chunkPos.x < 0.03125 || PSInput.chunkPos.x > 15.96875) || (PSInput.chunkPos.z < 0.03125 || PSInput.chunkPos.z > 15.96875)) &&
		(
			((cp.x < 0.03125 || cp.x > 0.96875) && (cp.y < 0.03125 || cp.y > 0.96875)) ||
			((cp.x < 0.03125 || cp.x > 0.96875) && (cp.z < 0.03125 || cp.z > 0.96875)) ||
			((cp.y < 0.03125 || cp.y > 0.96875) && (cp.z < 0.03125 || cp.z > 0.96875))
		)
	)
		diffuse.rgb =(diffuse.rgb/0.4f)*(float3(1.0f, 1.0f, 1.0f) - diffuse.rgb);

    cp.x=cp.x*3.0-1.1;
    cp.z=cp.z*3.0-1.1;


if(PSInput.color.r>0.999&&PSInput.color.g>50.0/255.0-0.001&&PSInput.color.g<50.0/255.0+0.001&&PSInput.color.b<0.001){
	if((cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.08&&cp.z>=0.05)||(cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.2&&cp.z>=0.17)
	 ||(floor(15.0/exp2(floor((4/0.6)*(cp.x-0.1))))%2>=0.5&&cp.z<=0.15&&cp.z>=0.1)||(cp.x<=0.7&&cp.x>=0.4&&cp.z<=0.35&&cp.z>=0.25)
	 ||(cp.x<=0.6&&cp.x>=0.5&&cp.z<=0.75&&cp.z>=0.35)||(cp.x<=0.7&&cp.x>=0.6&&cp.z<=0.75&&cp.z>=0.65)
	 ||(cp.x<=0.3&&cp.x>=0.2&&cp.z<=0.55&&cp.z>=0.45)
	 ||(cp.x<=0.2&&cp.x>=0.1&&cp.z<=0.55&&cp.z>=0.25)||(cp.x<=0.4&&cp.x>=0.3&&cp.z<=0.75&&cp.z>=0.45)
	 ||(cp.x<=0.3&&cp.x>=0.1&&cp.z<=0.75&&cp.z>=0.65)||(cp.x<=0.4&&cp.x>=0.2&&cp.z<=0.35&&cp.z>=0.25)){
        diffuse.rgb = float3(1.0f, 1.0f, 1.0f) * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
	}
}

if(PSInput.color.r>244.0/255.0-0.001&&PSInput.color.r<244.0/255.0+0.001&&PSInput.color.g>27.0/255.0-0.001&&PSInput.color.g<27.0/255.0+0.001&&PSInput.color.b<0.001){
	if((cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.08&&cp.z>=0.05)||(cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.2&&cp.z>=0.17)
	 ||(floor(14.0/exp2(floor((4/0.6)*(cp.x-0.1))))%2>=0.5&&cp.z<=0.15&&cp.z>=0.1)||(cp.x<=0.7&&cp.x>=0.4&&cp.z<=0.35&&cp.z>=0.25)
	 ||(cp.x<=0.6&&cp.x>=0.5&&cp.z<=0.75&&cp.z>=0.35)||(cp.x<=0.7&&cp.x>=0.6&&cp.z<=0.75&&cp.z>=0.65)
	 ||(cp.x<=0.2&&cp.x>=0.1&&cp.z<=0.75&&cp.z>=0.25)||(cp.x<=0.4&&cp.x>=0.3&&cp.z<=0.75&&cp.z>=0.45)
	 ||(cp.x<=0.3&&cp.x>=0.2&&cp.z<=0.55&&cp.z>=0.45)){
        diffuse.rgb = float3(1.0f, 1.0f, 1.0f) * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
	}
}

if(PSInput.color.r>234.0/255.0-0.001&&PSInput.color.r<234.0/255.0+0.001&&PSInput.color.g>6.0/255.0-0.001&&PSInput.color.g<6.0/255.0+0.001&&PSInput.color.b<0.001){
	if((cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.08&&cp.z>=0.05)||(cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.2&&cp.z>=0.17)
	 ||(floor(13.0/exp2(floor((4/0.6)*(cp.x-0.1))))%2>=0.5&&cp.z<=0.15&&cp.z>=0.1)||(cp.x<=0.7&&cp.x>=0.4&&cp.z<=0.35&&cp.z>=0.25)
	 ||(cp.x<=0.6&&cp.x>=0.5&&cp.z<=0.75&&cp.z>=0.35)||(cp.x<=0.7&&cp.x>=0.6&&cp.z<=0.75&&cp.z>=0.65)
	 ||(cp.x<=0.2&&cp.x>=0.1&&cp.z<=0.75&&cp.z>=0.25)||(cp.x<=0.4&&cp.x>=0.2&&cp.z<=0.55&&cp.z>=0.45)
	 ||(cp.x<=0.4&&cp.x>=0.2&&cp.z<=0.35&&cp.z>=0.25)||(cp.x<=0.4&&cp.x>=0.2&&cp.z<=0.75&&cp.z>=0.65)){
        diffuse.rgb = float3(1.0f, 1.0f, 1.0f) * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
	}
}

if(PSInput.color.r>224.0/255.0-0.001&&PSInput.color.r<224.0/255.0+0.001&&PSInput.color.g+PSInput.color.b<0.001){
	if((cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.08&&cp.z>=0.05)||(cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.2&&cp.z>=0.17)
	 ||(floor(12.0/exp2(floor((4/0.6)*(cp.x-0.1))))%2>=0.5&&cp.z<=0.15&&cp.z>=0.1)||(cp.x<=0.7&&cp.x>=0.4&&cp.z<=0.35&&cp.z>=0.25)
	 ||(cp.x<=0.6&&cp.x>=0.5&&cp.z<=0.75&&cp.z>=0.35)||(cp.x<=0.7&&cp.x>=0.6&&cp.z<=0.75&&cp.z>=0.65)
	 ||(cp.x<=0.3&&cp.x>=0.2&&cp.z<=0.55&&cp.z>=0.45)
	 ||(cp.x<=0.2&&cp.x>=0.1&&cp.z<=0.75&&cp.z>=0.45)||(cp.x<=0.4&&cp.x>=0.3&&cp.z<=0.55&&cp.z>=0.25)
	 ||(cp.x<=0.3&&cp.x>=0.1&&cp.z<=0.35&&cp.z>=0.25)||(cp.x<=0.4&&cp.x>=0.2&&cp.z<=0.75&&cp.z>=0.65)){
        diffuse.rgb = float3(1.0f, 1.0f, 1.0f) * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
	}
}

if(PSInput.color.r>214.0/255.0-0.001&&PSInput.color.r<214.0/255.0+0.001&&PSInput.color.g+PSInput.color.b<0.001){
	if((cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.08&&cp.z>=0.05)||(cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.2&&cp.z>=0.17)
	 ||(floor(11.0/exp2(floor((4/0.6)*(cp.x-0.1))))%2>=0.5&&cp.z<=0.15&&cp.z>=0.1)||(cp.x<=0.7&&cp.x>=0.4&&cp.z<=0.35&&cp.z>=0.25)
	 ||(cp.x<=0.6&&cp.x>=0.5&&cp.z<=0.75&&cp.z>=0.35)||(cp.x<=0.7&&cp.x>=0.6&&cp.z<=0.75&&cp.z>=0.65)
	 ||(cp.x<=0.4&&cp.x>=0.1&&cp.z<=0.35&&cp.z>=0.25)
	 ||(cp.x<=0.3&&cp.x>=0.2&&cp.z<=0.75&&cp.z>=0.35)||(cp.x<=0.4&&cp.x>=0.3&&cp.z<=0.75&&cp.z>=0.65)){
        diffuse.rgb = float3(1.0f, 1.0f, 1.0f) * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
	}
}

if(PSInput.color.r>204.0/255.0-0.001&&PSInput.color.r<204.0/255.0+0.001&&PSInput.color.g+PSInput.color.b<0.001){
	if((cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.08&&cp.z>=0.05)||(cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.2&&cp.z>=0.17)
	 ||(floor(10.0/exp2(floor((4/0.6)*(cp.x-0.1))))%2>=0.5&&cp.z<=0.15&&cp.z>=0.1)||(cp.x<=0.7&&cp.x>=0.4&&cp.z<=0.35&&cp.z>=0.25)
	 ||(cp.x<=0.6&&cp.x>=0.5&&cp.z<=0.75&&cp.z>=0.35)||(cp.x<=0.7&&cp.x>=0.6&&cp.z<=0.75&&cp.z>=0.65)
	 ||(cp.x<=0.2&&cp.x>=0.1&&cp.z<=0.75&&cp.z>=0.25)||(cp.x<=0.4&&cp.x>=0.3&&cp.z<=0.75&&cp.z>=0.25)
	 ||(cp.x<=0.3&&cp.x>=0.2&&cp.z<=0.75&&cp.z>=0.65)||(cp.x<=0.3&&cp.x>=0.2&&cp.z<=0.35&&cp.z>=0.25)){
        diffuse.rgb = float3(1.0f, 1.0f, 1.0f) * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
	}
}
if(PSInput.color.r>193.0/255.0-0.001&&PSInput.color.r<193.0/255.0+0.001&&PSInput.color.g+PSInput.color.b<0.001){
	if((cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.08&&cp.z>=0.05)||(cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.2&&cp.z>=0.17)
	 ||(floor(9.0/exp2(floor((4/0.6)*(cp.x-0.1))))%2>=0.5&&cp.z<=0.15&&cp.z>=0.1)||(cp.x<=0.3+0.15&&cp.x>=0.2+0.15&&cp.z<=0.55&&cp.z>=0.45)
	 ||(cp.x<=0.2+0.15&&cp.x>=0.1+0.15&&cp.z<=0.75&&cp.z>=0.35)||(cp.x<=0.4+0.15&&cp.x>=0.3+0.15&&cp.z<=0.75&&cp.z>=0.45)
	 ||(cp.x<=0.4+0.15&&cp.x>=0.1+0.15&&cp.z<=0.35&&cp.z>=0.25)||(cp.x<=0.4+0.15&&cp.x>=0.2+0.15&&cp.z<=0.75&&cp.z>=0.65)){
        diffuse.rgb = float3(1.0f, 1.0f, 1.0f) * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
	}
}

if(PSInput.color.r>183.0/255.0-0.001&&PSInput.color.r<183.0/255.0+0.001&&PSInput.color.g+PSInput.color.b<0.001){
	if((cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.08&&cp.z>=0.05)||(cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.2&&cp.z>=0.17)
	 ||(floor(8.0/exp2(floor((4/0.6)*(cp.x-0.1))))%2>=0.5&&cp.z<=0.15&&cp.z>=0.1)||(cp.x<=0.3+0.15&&cp.x>=0.2+0.15&&cp.z<=0.55&&cp.z>=0.45)
	 ||(cp.x<=0.2+0.15&&cp.x>=0.1+0.15&&cp.z<=0.75&&cp.z>=0.25)||(cp.x<=0.4+0.15&&cp.x>=0.3+0.15&&cp.z<=0.75&&cp.z>=0.25)
	 ||(cp.x<=0.3+0.15&&cp.x>=0.2+0.15&&cp.z<=0.75&&cp.z>=0.65)||(cp.x<=0.3+0.15&&cp.x>=0.2+0.15&&cp.z<=0.35&&cp.z>=0.25)){
        diffuse.rgb = float3(1.0f, 1.0f, 1.0f) * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
	}
}

if(PSInput.color.r>173.0/255.0-0.001&&PSInput.color.r<173.0/255.0+0.001&&PSInput.color.g+PSInput.color.b<0.001){
	if((cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.08&&cp.z>=0.05)||(cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.2&&cp.z>=0.17)
	 ||(floor(7.0/exp2(floor((4/0.6)*(cp.x-0.1))))%2>=0.5&&cp.z<=0.15&&cp.z>=0.1)||(cp.x<=0.2+0.15&&cp.x>=0.1+0.15&&cp.z<=0.75&&cp.z>=0.25)
	 ||(cp.x<=0.4+0.15&&cp.x>=0.2+0.15&&cp.z<=0.75&&cp.z>=0.65)||(cp.x<=0.4+0.15&&cp.x>=0.3+0.15&&cp.z<=0.65&&cp.z>=0.55)){
        diffuse.rgb = float3(1.0f, 1.0f, 1.0f) * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
	}
}

if(PSInput.color.r>163.0/255.0-0.001&&PSInput.color.r<163.0/255.0+0.001&&PSInput.color.g+PSInput.color.b<0.001){
	if((cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.08&&cp.z>=0.05)||(cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.2&&cp.z>=0.17)
	 ||(floor(6.0/exp2(floor((4/0.6)*(cp.x-0.1))))%2>=0.5&&cp.z<=0.15&&cp.z>=0.1)||(cp.x<=0.3+0.15&&cp.x>=0.2+0.15&&cp.z<=0.55&&cp.z>=0.45)
	 ||(cp.x<=0.2+0.15&&cp.x>=0.1+0.15&&cp.z<=0.55&&cp.z>=0.25)||(cp.x<=0.4+0.15&&cp.x>=0.3+0.15&&cp.z<=0.75&&cp.z>=0.35)
	 ||(cp.x<=0.3+0.15&&cp.x>=0.1+0.15&&cp.z<=0.75&&cp.z>=0.65)||(cp.x<=0.4+0.15&&cp.x>=0.2+0.15&&cp.z<=0.35&&cp.z>=0.25)){
        diffuse.rgb = float3(1.0f, 1.0f, 1.0f) * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
	}
}

if(PSInput.color.r>153.0/255.0-0.001&&PSInput.color.r<153.0/255.0+0.001&&PSInput.color.g+PSInput.color.b<0.001){
	if((cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.08&&cp.z>=0.05)||(cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.2&&cp.z>=0.17)
	 ||(floor(5.0/exp2(floor((4/0.6)*(cp.x-0.1))))%2>=0.5&&cp.z<=0.15&&cp.z>=0.1)||(cp.x<=0.3+0.15&&cp.x>=0.2+0.15&&cp.z<=0.55&&cp.z>=0.45)
	 ||(cp.x<=0.2+0.15&&cp.x>=0.1+0.15&&cp.z<=0.55&&cp.z>=0.25)||(cp.x<=0.4+0.15&&cp.x>=0.3+0.15&&cp.z<=0.75&&cp.z>=0.45)
	 ||(cp.x<=0.3+0.15&&cp.x>=0.1+0.15&&cp.z<=0.75&&cp.z>=0.65)||(cp.x<=0.4+0.15&&cp.x>=0.2+0.15&&cp.z<=0.35&&cp.z>=0.25)){
        diffuse.rgb = float3(1.0f, 1.0f, 1.0f) * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
	}
}

if(PSInput.color.r>142.0/255.0-0.001&&PSInput.color.r<142.0/255.0+0.001&&PSInput.color.g+PSInput.color.b<0.001){
	if((cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.08&&cp.z>=0.05)||(cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.2&&cp.z>=0.17)
	 ||(floor(4.0/exp2(floor((4/0.6)*(cp.x-0.1))))%2>=0.5&&cp.z<=0.15&&cp.z>=0.1)||(cp.x<=0.2+0.15&&cp.x>=0.1+0.15&&cp.z<=0.75&&cp.z>=0.25)
	 ||(cp.x<=0.4+0.15&&cp.x>=0.3+0.15&&cp.z<=0.75&&cp.z>=0.45)||(cp.x<=0.3+0.15&&cp.x>=0.2+0.15&&cp.z<=0.55&&cp.z>=0.45)){
        diffuse.rgb = float3(1.0f, 1.0f, 1.0f) * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
	}
}

if(PSInput.color.r>132.0/255.0-0.001&&PSInput.color.r<132.0/255.0+0.001&&PSInput.color.g+PSInput.color.b<0.001){
	if((cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.08&&cp.z>=0.05)||(cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.2&&cp.z>=0.17)
	 ||(floor(3.0/exp2(floor((4/0.6)*(cp.x-0.1))))%2>=0.5&&cp.z<=0.15&&cp.z>=0.1)
	 ||(cp.x<=0.2+0.15&&cp.x>=0.1+0.15&&cp.z<=0.75&&cp.z>=0.25)||(cp.x<=0.4+0.15&&cp.x>=0.2+0.15&&cp.z<=0.55&&cp.z>=0.45)
	 ||(cp.x<=0.4+0.15&&cp.x>=0.2+0.15&&cp.z<=0.35&&cp.z>=0.25)||(cp.x<=0.4+0.15&&cp.x>=0.2+0.15&&cp.z<=0.75&&cp.z>=0.65)){
        diffuse.rgb = float3(1.0f, 1.0f, 1.0f) * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
	}
}

if(PSInput.color.r>122.0/255.0-0.001&&PSInput.color.r<122.0/255.0+0.001&&PSInput.color.g+PSInput.color.b<0.001){
	if((cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.08&&cp.z>=0.05)||(cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.2&&cp.z>=0.17)
	 ||(floor(2.0/exp2(floor((4/0.6)*(cp.x-0.1))))%2>=0.5&&cp.z<=0.15&&cp.z>=0.1)||(cp.x<=0.3+0.15&&cp.x>=0.2+0.15&&cp.z<=0.55&&cp.z>=0.45)
	 ||(cp.x<=0.2+0.15&&cp.x>=0.1+0.15&&cp.z<=0.75&&cp.z>=0.45)||(cp.x<=0.4+0.15&&cp.x>=0.3+0.15&&cp.z<=0.55&&cp.z>=0.25)
	 ||(cp.x<=0.3+0.15&&cp.x>=0.1+0.15&&cp.z<=0.35&&cp.z>=0.25)||(cp.x<=0.4+0.15&&cp.x>=0.2+0.15&&cp.z<=0.75&&cp.z>=0.65)){
        diffuse.rgb = float3(1.0f, 1.0f, 1.0f) * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
	}
}

if(PSInput.color.r>112.0/255.0-0.001&&PSInput.color.r<112.0/255.0+0.001&&PSInput.color.g+PSInput.color.b<0.001){
	if((cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.08&&cp.z>=0.05)||(cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.2&&cp.z>=0.17)
	 ||(floor(1.0/exp2(floor((4/0.6)*(cp.x-0.1))))%2>=0.5&&cp.z<=0.15&&cp.z>=0.1)||(cp.x<=0.4+0.15&&cp.x>=0.1+0.15&&cp.z<=0.35&&cp.z>=0.25)
	 ||(cp.x<=0.3+0.15&&cp.x>=0.2+0.15&&cp.z<=0.75&&cp.z>=0.35)||(cp.x<=0.4+0.15&&cp.x>=0.3+0.15&&cp.z<=0.75&&cp.z>=0.65)){
        diffuse.rgb = float3(1.0f, 1.0f, 1.0f) * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
	}
}

if(PSInput.color.r>76.0/255.0-0.001&&PSInput.color.r<76.0/255.0+0.001&&PSInput.color.g+PSInput.color.b<0.001){
	if((cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.08&&cp.z>=0.05)||(cp.x<=0.7&&cp.x>=0.1&&cp.z<=0.2&&cp.z>=0.17)
	 ||(cp.x<=0.2+0.15&&cp.x>=0.1+0.15&&cp.z<=0.75&&cp.z>=0.25)||(cp.x<=0.4+0.15&&cp.x>=0.3+0.15&&cp.z<=0.75&&cp.z>=0.25)
	 ||(cp.x<=0.3+0.15&&cp.x>=0.2+0.15&&cp.z<=0.75&&cp.z>=0.65)||(cp.x<=0.3+0.15&&cp.x>=0.2+0.15&&cp.z<=0.35&&cp.z>=0.25)){
        diffuse.rgb = float3(1.0f, 1.0f, 1.0f) * TEXTURE_1.Sample(TextureSampler1, PSInput.uv1);
	}
}

#ifdef FOG
	diffuse.rgb = lerp( diffuse.rgb, PSInput.fogColor.rgb, PSInput.fogColor.a );
#endif

	PSOutput.color = diffuse;

#ifdef VR_MODE
	// On Rift, the transition from 0 brightness to the lowest 8 bit value is abrupt, so clamp to 
	// the lowest 8 bit value.
	PSOutput.color = max(PSOutput.color, 1 / 255.0f);
#endif

#endif // BYPASS_PIXEL_SHADER
}