import { world, ItemStack, MinecraftItemTypes } from 'mojang-minecraft';

const errorDescription = "An Error occurs when trying to create an empty stack.";
const errorCode = "const stack = new ItemStack(MinecraftItemTypes.air);";

world.events.tick.subscribe(runListener);

function runListener(event) {
    if (event.currentTick % 200 == 0) {
        try {
            runIntoBug();
        } catch (error) {
            sendError(error);
        }
    }
}
function runIntoBug() {
    const stack = new ItemStack(MinecraftItemTypes.air);
}
function sendError(error) {

    const msg = {
        rawtext: [{
            text: `§4§lERROR§r\n` +//§r
                `§lDescription:§r ${errorDescription}\n` +
                `§lCode:§r ${errorCode}\n` +
                `§lErrorName:§r ${error.name}\n` +
                `§lErrorMessage:§r ${error.message}\n` +
                `§lErrorStack:§r ${error.stack}`
        }]
    };
    try {
        world.getDimension("overworld").runCommand("tellraw @a " + JSON.stringify(msg));
    } catch (error) {
    }
}