import * as Minecraft from "@minecraft/server";
Minecraft.world.afterEvents.worldInitialize.subscribe((e) => {
    let def = new Minecraft.DynamicPropertiesDefinition();
    for (let counter = 0; counter < 10; counter++) {
        def.defineNumber("wc" + counter + "x");
        def.defineNumber("wc" + counter + "y");
        def.defineNumber("wc" + counter + "z");
    }
    e.propertyRegistry.registerWorldDynamicProperties(def);
});
function showpos(Player, xpos, ypos, zpos) {
    Player.sendMessage(`function showpos : placed windowcontroller on ${Player.name} : ${xpos}, ${ypos}, ${zpos}`);
}
Minecraft.world.afterEvents.blockPlace.subscribe((placed) => {
    let player = placed.player;
    let block = placed.block;
    let blockID = placed.block.typeId;
    let xpos = placed.block.x;
    let ypos = placed.block.y;
    let zpos = placed.block.z;
    Minecraft.world.sendMessage(`Block place detected : ${blockID}`);
});
Minecraft.world.afterEvents.blockBreak.subscribe((broken) => {
    let blockID = broken.brokenBlockPermutation.type.id;
    let xpos = broken.block.x;
    let ypos = broken.block.y;
    let zpos = broken.block.z;
    Minecraft.world.sendMessage(`Block break detected in : ${blockID} at ${xpos},${ypos},${zpos}`);
});
function sleep(milliseconds) {
    const date = Date.now();
    let currentDate = null;
    do {
        currentDate = Date.now();
    } while (currentDate - date < milliseconds);
}
function MagicWindowX(block, xpos, ypos, zpos) {
    let redstonepower = 0; // redstone power of lever
    let xposOffset = 2;
    let fbT;
    const overworld = Minecraft.world.getDimension("overworld");
    let rsp = block.getRedstonePower();
    let rspB; // redstone power of affected block
    if (rsp != undefined)
        redstonepower = rsp;
    // lever set to on
    if (redstonepower > 0) {
        let fb = overworld.getBlock({ x: xpos + xposOffset, y: ypos, z: zpos });
        if (fb != undefined) {
            fbT = fb.typeId;
            Minecraft.world.sendMessage(`BlockID: ${fbT}, ${xpos},${ypos},${zpos}`);
            while (fbT == 'bridge:mystglass') {
                fb = overworld.getBlock({ x: xposOffset + xpos, y: ypos, z: zpos });
                fbT = fb?.typeId;
                rspB = fb?.getRedstonePower();
                if (rspB != undefined && rspB > 0)
                    fb?.setPermutation(Minecraft.BlockPermutation.resolve("bridge:mystglass", { 'custom:is_trans': false }));
                xposOffset++;
                fb = overworld.getBlock({ x: xposOffset + xpos, y: ypos, z: zpos });
                fbT = fb?.typeId;
            }
        }
    }
    if (redstonepower == 0) {
        let fb = overworld.getBlock({ x: xpos + 2, y: ypos, z: zpos });
        if (fb != undefined) {
            fbT = fb.typeId;
            while (fbT == 'bridge:mystglass') {
                fb = overworld.getBlock({ x: xpos + xposOffset, y: ypos, z: zpos });
                fbT = fb?.typeId;
                rspB = fb?.getRedstonePower();
                if (rspB != undefined && rspB == 0)
                    fb?.setPermutation(Minecraft.BlockPermutation.resolve("bridge:mystglass", { 'custom:is_trans': true }));
                xposOffset++;
                fb = overworld.getBlock({ x: xposOffset + xpos, y: ypos, z: zpos });
                fbT = fb?.typeId;
            }
        }
    }
}
Minecraft.world.afterEvents.leverActivate.subscribe((event) => {
    const player = event.player;
    let block = event.block;
    let leverXpos = event.block.x;
    let leverYpos = event.block.y;
    let leverZpos = event.block.z;
    let lx = event.block.x;
    let ly = event.block.y;
    let lz = event.block.z;
    let wcontroller;
    let wcx = Minecraft.world.getDynamicProperty("wc1x");
    let wcy = Minecraft.world.getDynamicProperty("wc1y");
    let wcz = Minecraft.world.getDynamicProperty("wc1z");
    Minecraft.world.sendMessage(`WindowController is on ${wcx}, ${wcy}, ${wcz} `);
    //while (wcontroller != 'bridge:windowcontroller' ) {
    //	wcontroller=Minecraft.world.getDimension("overworld").getBlock({x:lx+1,y:ly,z:lz})?.typeId;
    //}
    // MagicWindowX(block, leverXpos, leverYpos, leverZpos);
});

//# sourceMappingURL=../../_ts-testDebug/main.js.map
