import { world, Vector, system, Direction } from '@minecraft/server';

const DirectionToVector = {
	[Direction.Down]: Vector.down,
	[Direction.Up]: Vector.up,
	[Direction.North]: Vector.forward,
	[Direction.South]: Vector.back,
	[Direction.West]: Vector.left,
	[Direction.East]: Vector.right,
};
function floorVector3(vector) {
	return {
		x: Math.floor(vector.x),
		y: Math.floor(vector.y),
		z: Math.floor(vector.z),
	};
}
world.beforeEvents.itemUseOn.subscribe(async (event) => {
	try {

		const { source, block, blockFace, faceLocation } = event;


		// logVector3(DirectionToVector[blockFace]);
		const placeLocation = Vector.add(block.location, DirectionToVector[blockFace]);
		const predictedPlaceLocation = Vector.add(block.location, floorVector3(faceLocation));
		await null;
		world.sendMessage('============================================');
		world.sendMessage(JSON.stringify({ "§7not Floored faceLocation§f": faceLocation }, null));
		world.sendMessage(JSON.stringify({ blockFace, "§7Floored faceLocation§f": floorVector3(faceLocation) }));
		world.sendMessage('§7Floored faceLocation + block.location: §cminecraft:villager_angry paricle and red_stained_glass');
		world.sendMessage('§7blockFace converted to vector + block.location: §aminecraft:villager_happy paricle and lime_stained_glass\n§7(if place location for both is correct it will be lime)');
		world.sendMessage('§7block.location: §fminecraft:endrod paricle(will be where faceLocation is relitive from) and glass ');
		source.dimension.spawnParticle('minecraft:villager_angry', predictedPlaceLocation);
		source.dimension.spawnParticle('minecraft:endrod', block.location);
		source.dimension.spawnParticle('minecraft:villager_happy', placeLocation);
		source.dimension.getBlock(block.location).setType('glass');
		source.dimension.getBlock(predictedPlaceLocation).setType('red_stained_glass');
		source.dimension.getBlock(placeLocation).setType('lime_stained_glass');
	} catch (error) {
		console.warn(error, error.stack);
	}
});
function rotationToDirection(rotation) {
	let { x, y } = rotation;

	x = (x / 45 + 2) | 0;
	y = ((y + 45) / 90 + 2) | 0;
	if (x < 1) return 'Up (y + 1)';
	else if ((x > 2)) return 'Down (y - 1)';
	switch (y) {
		case 2:
			return 'North (z + 1)';
		case 4:
		case 0:
			return 'South (z - 1)';
		case 1:
			return 'East (x + 1)';
		case 3:
			return 'West (x - 1)';
	}
};
system.runInterval(() => {
	const players = world.getAllPlayers();
	players.forEach(player => {
		player.onScreenDisplay.setActionBar(rotationToDirection(player.getRotation()) ?? "None" + '\n(based off Direction Enum on docs)');
	});
});
// system.runInterval(() => {
// 	const player = world.getAllPlayers()[0];
// 	player.dimension.spawnParticle('minecraft:villager_angry', { x: 39, y: 68, z: 106 });
// });
