#=======================#
# Tyruswoo Game Changer #
# Settings              #
#=======================#
# Note: These settings are run ("read") only when the Game Changer is started (by typing /function Tyruswoo:GameChanger).

# SETTINGS: Change these preferences to your desired settings!  (This file will run when you use /function GameChanger2 to start the machine.)

#====================================#
# GAME LOOP OPTIONS                  #
#====================================#
# Here we select which function will be our game loop function.  The game loop function is what determines how safely and quickly the Game Changer operates.
# The more quickly the Game Changer operates, the more instantaneously its functions happen. Particularly, on higher settings, structures generate in more quickly.
# However, the more quickly the Game Changer runs, the more likely that Minecraft will crash!  Note: If you are running a Minecraft server, game crashes are more likely.
# Clock1 for Ultra Safe										Use this setting if you are running a server that reboots infrequently (i.e. daily).  Least likely to crash.  Also, use this setting if the normal (recommended) setting fails to work.  Structures may load in noticeably slowly, appearing about 10 to 20 minutes after exploring a new area.
# Clock2 for Safe (Recommended for Servers)					A reasonable choice for servers.  Use this setting if you are experiencing crashes in single player.  Structures may load in somewhat slowly, appearing a minute or two after exploring a new area.
# Clock3 for Balanced (Recommended for Single Player)		Recommended for both Single Player, and for servers with plenty of RAM allotted to Minecraft.  Structures will load in within several seconds of exploring a new area.  Lag when fighting enemies is very rare, even on servers.
# Clock4 for Fast											Use this setting if your computer is very beefy.  May cause crashes on servers with too little RAM allotted to Minecraft.  On servers with plenty of RAM allotted to Minecraft, may still notice lag when fighting enemies or mining blocks.  Structures will load in within a few seconds of exploring a new area, with an extra boost to structure location preparation speed.
# Clock5 for Extremely Fast									Use this setting if your computer is too beefy for words.  Only use on single player.  Do not try this on multiplayer!  Expect frequest crashes on servers, unless your server is very powerful and has lots of RAM allotted to Minecraft.  Structures will load in within a few seconds of exploring a new area, with a large boost to structure location preparation speed.  Clock 5 (Ultra Fast) is only marginally faster than Clock 4 (Fast), but the chance of lag while fighting enemies, or crashing the server, is greatly increased.
# By default, we will use the Balanced (Recommended for Single Player) setting. Please change it below if you would like a different setting.  You can also change it in game (see help), but only after you have already started the Game Changer.
function Tyruswoo:StartClock3

#====================================#
# DENSITY OF STRUCTURE GENERATION    #
#====================================#
# DENSITY SETTINGS:
# How close together do you want structures to generate into your world? 4 for most dense, 1 for least dense.
# In the command below, you can change the number to any of the following:
# 1 for Sparse						Sparse is similar to the rarity of Minecraft's default structures.  Structures are sometimes found, but they are rare.
# 2 for Normal (Recommended) 		Normal is good for worlds with plenty of interesting things, but allowing those things to be avoided.
# 3 for Common 						Common is good for worlds of survival adventure, where structures are often found, and danger is likely to find you.  Certain structure pack may have more challenge than others, depending on the structure pack.
# 4 for Extremely Abundant			Extremely abundant is the highest difficulty, and the most extreme challenge.  Certain structure packs may have more challenge than others, depending on the structure pack.
# Note: If you manually set the density in game using functions, either before or after starting the Game Changer, the manually set density overrides this default setting.
scoreboard players set TyrSettings TyrDensity 2

#====================================#
# SPECTATOR MODE OPTION              #
#====================================#
# Would you like to enter Spectator Mode as soon as you start the Game Changer?  This allows you to move through walls and can make it easier to see structures generate.
# You can always switch back to Survival Mode by typing this command into chat: /gamemode survival
# Then, drink a bucket of milk to remove the night vision and water breathing effects (I give you these in Spectator Mode because it makes it easier to see structures).
# If you do not want to automatically enter Spectator Mode when you start the Game Changer, you can type "#" at the beginning of the next line to turn it into a comment.
# function Tyruswoo:Spectate

#====================================#
# SHOW HELP OPTION                   #
#====================================#
# By default, the help options are displayed automatically when the Game Changer is started.
# If you do not want to automatically receive help information when you start the Game Changer, you can type "#" at the beginning of the next line to turn it into a comment.
function Tyruswoo:GameChanger/Help

#====================================#
# NUMBER OF STRUCTURES IN EACH BIOME #
#====================================#
# Please see the Tyruswoo:BiomeSettings file if you wish to change the number of structures the Game Changer should expect from each of the structure pack's biomes.
