#====================================================================================================
# Scatter Structures: Set 35
# by Tyruswoo
#====================================================================================================
# When a structure is loaded in, and is intended to be a scatter group, it can use this set to get started.

# Summon desired number of armor stands, representing the desired number of scatter structures.
# Let's summon 20 armor stands, enough so all 20 of this group's scatter structures can be spawned only once.
# Change the number of times this command is repeated if you want more or less structures from each scattering.
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}
summon armor_stand ~ ~ ~ {CustomName:TyrScatter,NoGravity:1,Invisible:1}

# Give each armor stand a desired TyrGroup number. We always need to do this.
# Let's have the group number match this function's set number. Always do this, unless you have an advanced understanding of command functions, structure blocks, and the Creation Station.
scoreboard players set @e[type=armor_stand,name=TyrScatter,r=10] TyrGroup 35

# Give each armor stand a desired default TyrStructure number.
# Always do this.
scoreboard players set @e[type=armor_stand,name=TyrScatter,r=10] TyrStructure 1

# Give each armor stand a desired TyrStructure number.
# Let's let each number from 1 to 20 be represented, so all 20 of this group's scatter structures spawn once.
# These commands can be modified by removing the "score" requirement, resulting in pseudo-random structure selection within the group.
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 2
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 3
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 4
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 5
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 6
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 7
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 8
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 9
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 10
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 11
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 12
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 13
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 14
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 15
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 16
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 17
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 18
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 19
scoreboard players set @r[type=armor_stand,name=TyrScatter,r=10,score_TyrStructure=1] TyrStructure 20

# Change names to TyrScatter2 ("PrepareLocation").
# We always need to do this.
execute @e[type=armor_stand,name=TyrScatter,r=10] ~ ~ ~ entitydata @s {CustomName:TyrScatter2}

# Scatter all nearby armor stands.
# Let's let them each be separated by 5 blocks, and over an area 30 blocks wide. Modify those numbers to change the distance between structures, and the area over which the structures spread.
spreadplayers ~ ~ 5 30 false @e[type=armor_stand,name=TyrScatter2,r=10]

# Delete nearby command block and observer block used in loading the structure root.
# We always need to do this.
fill ~ ~-1 ~ ~ ~ ~ minecraft:air