#==============================#
# Tyruswoo Structure Generator #
# Protect                      #
#==============================#
# Protects a 300x300 area, so it cannot generate structures. Use this to protect your base before you turn on the Game Changer.
# Overworld, Nether, and End are all protected using barrier blocks at certain y levels.
# For overworld & Nether, barrier blocks are set at y=1. For End, barrier blocks are set at y=0.
# For this reason, we need to know whether we are protecting Overworld or Nether, or the End, because the End is protected differently.
# We activate the appropriate protection, depending on the dimension detected.

# OVERWORLD & NETHER
# We check for bedrock at y=0 to make sure we are in the Overworld or the Nether.
execute @s ~ ~ ~ detect ~ 0 ~ minecraft:bedrock -1 function Tyruswoo:GameChanger/StructureGenerator/Protect/Protect

# END
# We check for air at the y=1 layer, because we want protection to run, even if actually inside a nearby area where protection has run.
execute @s ~ ~ ~ detect ~ 1 ~ minecraft:air -1 function Tyruswoo:GameChanger/StructureGenerator/Protect/ProtectEnd
execute @s ~ ~ ~ detect ~ 1 ~ minecraft:obsidian -1 function Tyruswoo:GameChanger/StructureGenerator/Protect/ProtectEnd
