#===============================================#
# Structure Generator: Scatter Detect Dimension #
# by Tyruswoo                                   #
#===============================================#

# Identify the dimension of each TyrScatter armor stand, and assign it the correct dimension.

# Since this function uses "detect" in all the execute commands, the dimension can only be detected when chunks are loaded.
# Therefore, this function doubles as Chunk Loaded Detection.

# OVERWORLD: Dimension 1
# Assume armor stand is in the Overworld
execute @e[type=armor_stand,name=TyrScatter2] ~ ~ ~ scoreboard players set @s TyrDimension 1

# NETHER: Dimension 2
# If we detect bedrock at y=127, we know the armor stand is in the Nether. (This overrides any false assumptions of Overworld.)
execute @e[type=armor_stand,name=TyrScatter2] ~ ~ ~ detect ~ 127 ~ minecraft:bedrock -1 scoreboard players set @s TyrDimension 2

# END: Dimension 3
# If we detect air at y=1, we know the armor stand is in the End, and the chunks have not yet been scanned.
# If we detect obsidian at y=1, we know the armor stand is in the End, and the chunks have not yet been scanned.
execute @e[type=armor_stand,name=TyrScatter2] ~ ~ ~ detect ~ 1 ~ minecraft:air -1 scoreboard players set @s TyrDimension 3
execute @e[type=armor_stand,name=TyrScatter2] ~ ~ ~ detect ~ 1 ~ minecraft:obsidian -1 scoreboard players set @s TyrDimension 3
