#=====================================================================================================
# Tyruswoo Structure Generator: Scan Prepare For Expand
#=====================================================================================================
# Rename armor stands as needed, so that they are ready for their new roles, prior to scan expansion.

# END only
# execute @e[type=armor_stand,name=TyrStructure2,score_TyrDimension_min=3,score_TyrDimension=3] ~ ~ ~ tp @s ~ 255 ~

# For all TyrStructure2 ("Generating") armor stands that have been selected for a structure (by receiving a biome identity), rename them as TyrStructure3 ("Prepare Location") armor stands.
entitydata @e[type=armor_stand,name=TyrStructure2,score_TyrBiome_min=1] {CustomName:TyrStructure3}

# Destroy all TyrStructure2 ("Generating") armor stands that were not selected for a structure (by receiving a biome identity).
kill @e[type=armor_stand,name=TyrStructure2]

# OVEROWRLD & NETHER: Place black wool wherever there is no structure, and also perform pentuple and hextuplecheck that barrier blocks and bedrock are placed there.
execute @e[type=armor_stand,name=TyrStructure1,score_TyrDimension_min=1,score_TyrDimension=2] ~ ~ ~ fill ~-30 0 ~-30 ~30 0 ~30 minecraft:wool 15 replace minecraft:bedrock
execute @e[type=armor_stand,name=TyrStructure1,score_TyrDimension_min=1,score_TyrDimension=2] ~ ~ ~ fill ~-30 1 ~-30 ~30 1 ~30 minecraft:barrier
execute @e[type=armor_stand,name=TyrStructure1,score_TyrDimension_min=1,score_TyrDimension=2] ~ ~ ~ fill ~-30 2 ~-30 ~30 2 ~30 minecraft:bedrock
execute @e[type=armor_stand,name=TyrStructure1,score_TyrDimension_min=1,score_TyrDimension=2] ~ ~ ~ fill ~-32 1 ~-32 ~32 1 ~32 minecraft:barrier
execute @e[type=armor_stand,name=TyrStructure1,score_TyrDimension_min=1,score_TyrDimension=2] ~ ~ ~ fill ~-32 2 ~-32 ~32 2 ~32 minecraft:bedrock

# OVERWORLD (Dimension 1) & NETHER (Dimension 2): Protect lowest layers of map with bedrock at layer 2, and mark area as generated by placing barrier blocks at layer 1.
execute @e[type=armor_stand,name=TyrStructure1,score_TyrDimension_min=1,score_TyrDimension=2] ~ ~ ~ fill ~-33 1 ~-33 ~33 1 ~33 minecraft:barrier
execute @e[type=armor_stand,name=TyrStructure1,score_TyrDimension_min=1,score_TyrDimension=2] ~ ~ ~ fill ~-33 2 ~-33 ~33 2 ~33 minecraft:bedrock

# END: Mark area as generated by placing barrier blocks at layer 0.
execute @e[type=armor_stand,name=TyrStructure1,score_TyrDimension_min=3,score_TyrDimension=3] ~ ~ ~ fill ~-33 0 ~-33 ~33 0 ~33 minecraft:barrier

# Rename TyrStructure1 ("Generator") armor stands to TyrStructure2 ("Generating").
execute @e[type=armor_stand,name=TyrStructure1] ~ ~ ~ entitydata @s {CustomName:TyrStructure2}

# Rename TyrStructure0 ("PreGenerator") armor stands to TyrStructure1 ("Generator"), but only if the armor stand's dimension was correctly detected (which can only happen if chunks are loaded).
execute @e[type=armor_stand,name=TyrStructure0,score_TyrDimension_min=1] ~ ~ ~ entitydata @s {CustomName:TyrStructure1}

# Prepare armor stands for Nudge, if likely needed.
# OVERWORLD & NETHER
execute @e[type=armor_stand,name=TyrStructure1] ~ ~ ~ detect ~30 1 ~ minecraft:barrier -1 entitydata @s {CustomName:TyrStructureNudge}
execute @e[type=armor_stand,name=TyrStructure1] ~ ~ ~ detect ~ 1 ~30 minecraft:barrier -1 entitydata @s {CustomName:TyrStructureNudge}
execute @e[type=armor_stand,name=TyrStructure1] ~ ~ ~ detect ~-30 1 ~ minecraft:barrier -1 entitydata @s {CustomName:TyrStructureNudge}
execute @e[type=armor_stand,name=TyrStructure1] ~ ~ ~ detect ~ 1 ~-30 minecraft:barrier -1 entitydata @s {CustomName:TyrStructureNudge}
# END
execute @e[type=armor_stand,name=TyrStructure1] ~ ~ ~ detect ~30 0 ~ minecraft:barrier -1 entitydata @s {CustomName:TyrStructureNudge}
execute @e[type=armor_stand,name=TyrStructure1] ~ ~ ~ detect ~ 0 ~30 minecraft:barrier -1 entitydata @s {CustomName:TyrStructureNudge}
execute @e[type=armor_stand,name=TyrStructure1] ~ ~ ~ detect ~-30 0 ~ minecraft:barrier -1 entitydata @s {CustomName:TyrStructureNudge}
execute @e[type=armor_stand,name=TyrStructure1] ~ ~ ~ detect ~ 0 ~-30 minecraft:barrier -1 entitydata @s {CustomName:TyrStructureNudge}

# Revert from Nudge preparations, if actually not needed.
# OVERWORLD
execute @e[type=armor_stand,name=TyrStructureNudge] ~ ~ ~ detect ~-30 1 ~ minecraft:barrier -1 execute @s ~ ~ ~ detect ~30 1 ~ minecraft:barrier -1 entitydata @s {CustomName:TyrStructure1}
execute @e[type=armor_stand,name=TyrStructureNudge] ~ ~ ~ detect ~ 1 ~-30 minecraft:barrier -1 execute @s ~ ~ ~ detect ~ 1 ~30 minecraft:barrier -1 entitydata @s {CustomName:TyrStructure1}
# END
execute @e[type=armor_stand,name=TyrStructureNudge] ~ ~ ~ detect ~-30 0 ~ minecraft:barrier -1 execute @s ~ ~ ~ detect ~30 0 ~ minecraft:barrier -1 entitydata @s {CustomName:TyrStructure1}
execute @e[type=armor_stand,name=TyrStructureNudge] ~ ~ ~ detect ~ 0 ~-30 minecraft:barrier -1 execute @s ~ ~ ~ detect ~ 0 ~30 minecraft:barrier -1 entitydata @s {CustomName:TyrStructure1}

# Nudge
execute @e[type=armor_stand,name=TyrStructureNudge] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Entity/Nudge
