#============================================#
# Structure Generator: Scan Detect Dimension #
# by Tyruswoo                                #
#============================================#

# Identify the dimension of each TyrStructure0 armor stand, and assign it the correct dimension.

# Since this function uses "detect" in all the execute commands, the dimension can only be detected when chunks are loaded.
# Therefore, this function doubles as Chunk Loaded Detection.

# OVERWORLD: Dimension 1
# If we detect bedrock at y=0, we know the armor stand is either in the Overworld or the Nether, and the chunks have not yet been scanned. Assume it is in the Overworld.
execute @e[type=armor_stand,name=TyrStructure0] ~ ~ ~ detect ~ 0 ~ minecraft:bedrock -1 scoreboard players set @s TyrDimension 1

# NETHER: Dimension 2
# If we detect bedrock at y=127, we know the armor stand is in the Nether, and the chunks have not yet been scanned. (This overrides any false assumptions of Overworld.)
execute @e[type=armor_stand,name=TyrStructure0] ~ ~ ~ detect ~ 127 ~ minecraft:bedrock -1 scoreboard players set @s TyrDimension 2

# END: Dimension 3
# If we detect air at y=0 and air at y=255, we know the armor stand is in the End, and the chunks have not yet been scanned.
# If we detect obsidian at y=0 and air at y=255, we know the armor stand is in the End, and the chunks have not yet been scanned.
execute @e[type=armor_stand,name=TyrStructure0] ~ ~ ~ detect ~ 0 ~ minecraft:air -1 scoreboard players set @s TyrDimension 3
execute @e[type=armor_stand,name=TyrStructure0] ~ ~ ~ detect ~ 0 ~ minecraft:obsidian -1 scoreboard players set @s TyrDimension 3
