#======================================================================================================
# If an armor stand passes the density check, set its TyrDensityPass variable to 1 to indicate a pass.
# Check all TyrStructure2 ("Generating") armor stands.
#======================================================================================================

# Give all TyrStructure2 ("Generating") armor stands a copy of the TyrDensity value stored in TyrTimer.
scoreboard players operation @e[type=armor_stand,name=TyrStructure2] TyrDensity = TyrTimer TyrDensity

# EXTREMELY ABUNDANT: All armor stands pass.
execute @e[type=armor_stand,name=TyrStructure2,score_TyrDensity_min=4,score_TyrDensity=4] ~ ~ ~ scoreboard players set @s TyrDensityPass 1

# COMMON: Many armor stands pass.
execute @e[type=armor_stand,name=TyrStructure2,score_TyrDensity_min=3,score_TyrDensity=3] ~ ~ ~ detect ~ 3 ~ minecraft:bedrock -1 scoreboard players set @s TyrDensityPass 1

# NORMAL (RECOMMENDED) & SPARSE: Some armor stands pass.
execute @e[type=armor_stand,name=TyrStructure2,score_TyrDensity_min=1,score_TyrDensity=2] ~ ~ ~ detect ~ 4 ~ minecraft:bedrock -1 scoreboard players set @s TyrDensityPass 1

# SPARSE: Few armor stands pass (so we need to make sparse even less than normal).
execute @e[type=armor_stand,name=TyrStructure2,score_TyrDensity_min=1,score_TyrDensity=1] ~ ~ ~ detect ~ 3 ~ minecraft:bedrock -1 scoreboard players set @s TyrDensityPass 0

#======================================================================================================

# END
# The only setting is Extremely Abundant.
# Therefore, to modify density of structures in the End, the only way is by changing the Upper Bound in the Tyruswoo:GameChanger/Settings.mcfunction file.
execute @e[type=armor_stand,name=TyrStructure2,score_TyrDimension_min=3,score_TyrDimension=3] ~ ~ ~ scoreboard players set @s TyrDensityPass 1

#======================================================================================================

# Protect players from structures spawning on top of them (as might occur after a New Scan has begun).
execute @a ~-32 0 ~-32 scoreboard players set @e[type=armor_stand,name=TyrStructure2,dx=64,dy=255,dz=64] TyrDensityPass 0

#======================================================================================================

# If armor stand passes the density check, then this armor stand will spawn in a structure!
# Let's spread these armor stands to the surface of the Overworld (or top of the Nether, or a nearby End island, depending on the dimension).
execute @e[type=armor_stand,name=TyrStructure2,score_TyrDensityPass_min=1] ~ ~ ~ spreadplayers ~ ~ 0 1 false @s
