#======================================#
# Entity: Prepare Location (Overworld) #
# by Tyruswoo                          #
#======================================#
# Prepares the armor stand's location so that it is in a good place for structures to be loaded in (such as the surface of the Overworld, not up in a tree).

# For the overworld, the armor stand's default location should be the surface, wherever the surface is.
# The armor stand by default is at y=62, at ocean level.  The armor stand is spread to the surface once, before biome detection.
# Then, during the ScanFinishCycle function, the armor stand was spread to the surface within a radius, to achieve final x and z coordinates.
# Now, we just need to make sure the armor stand is at a y coordinate that corresponds with the actual surface, as the default location.

# Make sure the armor stand is at the actual surface (not up in a tree or something).
# To do this, we check if the armor stand is on a qualifying block.  If yes, we change the armor stand's name to TyrStructure4 ("Loading Structure").
# If not, the armor stand will be able to complete this function, resulting in decreasing the y coordinate by 1.
execute @s[name=TyrStructure3] ~ ~ ~ detect ~ ~-1 ~ minecraft:grass -1 entitydata @s {CustomName:TyrStructure4}
execute @s[name=TyrStructure3] ~ ~ ~ detect ~ ~-1 ~ minecraft:stone -1 entitydata @s {CustomName:TyrStructure4}
execute @s[name=TyrStructure3] ~ ~ ~ detect ~ ~-1 ~ minecraft:dirt -1 entitydata @s {CustomName:TyrStructure4}
execute @s[name=TyrStructure3] ~ ~ ~ detect ~ ~-1 ~ minecraft:sand -1 entitydata @s {CustomName:TyrStructure4}
execute @s[name=TyrStructure3] ~ ~ ~ detect ~ ~-1 ~ minecraft:sandstone -1 entitydata @s {CustomName:TyrStructure4}
execute @s[name=TyrStructure3] ~ ~ ~ detect ~ ~-1 ~ minecraft:hardened_clay -1 entitydata @s {CustomName:TyrStructure4}
execute @s[name=TyrStructure3] ~ ~ ~ detect ~ ~-1 ~ minecraft:stained_hardened_clay -1 entitydata @s {CustomName:TyrStructure4}
execute @s[name=TyrStructure3] ~ ~ ~ detect ~ ~-1 ~ minecraft:mycelium -1 entitydata @s {CustomName:TyrStructure4}
execute @s[name=TyrStructure3] ~ ~ ~ detect ~ ~-1 ~ minecraft:water -1 entitydata @s {CustomName:TyrStructure4}
execute @s[name=TyrStructure3] ~ ~ ~ detect ~ ~-1 ~ minecraft:lava -1 entitydata @s {CustomName:TyrStructure4}
execute @s[name=TyrStructure3] ~ ~ ~ detect ~ ~-1 ~ minecraft:gravel -1 entitydata @s {CustomName:TyrStructure4}
execute @s[name=TyrStructure3] ~ ~ ~ detect ~ ~-1 ~ minecraft:snow -1 entitydata @s {CustomName:TyrStructure4}
execute @s[name=TyrStructure3] ~ ~ ~ detect ~ ~-1 ~ minecraft:ice -1 entitydata @s {CustomName:TyrStructure4}
execute @s[name=TyrStructure3] ~ ~ ~ detect ~ ~-1 ~ minecraft:grass_path -1 entitydata @s {CustomName:TyrStructure4}
execute @s[name=TyrStructure3] ~ ~ ~ detect ~ ~-1 ~ minecraft:coal_ore -1 entitydata @s {CustomName:TyrStructure4}
execute @s[name=TyrStructure3] ~ ~ ~ detect ~ ~-1 ~ minecraft:iron_ore -1 entitydata @s {CustomName:TyrStructure4}

# If the armor stand is still named TyrStructure3 ("Prepare Location"), then its current location did not qualify, so move it down one block, so its ready to check again next tick.
execute @s[name=TyrStructure3] ~ ~ ~ tp @s ~ ~-1 ~
