#================================#
# Entity: Prepare Location (End) #
# by Tyruswoo                    #
#================================#

# For the End, we will let the default location for structures be at y=63, which is about the top of most End islands.
# The armor stand by default is at y=63 (at ocean level in the Overworld, which also happens to correspond with the surface of most End islands).
# The armor stand is spread once, before biome detection, which will result in the armor stand being on top of the barrier blocks marking the End,
# because the spreadplayers command does not recognize the naturally spawning blocks in the End (except maybe obsidian and bedrock near the dragon fight area?).
# Then, during the ScanFinishCycle function, the armor stand was spread again within a radius, to achieve final x and z coordinates (still on top of the barrier block layer).
# Now, we just need to make sure the armor stand is at a y coordinate that appears to be the surface of an End island, if there is one at the armor stand's x and z coordinates.
# Finding the surface of an End island is relatively easy in the End, because the islands are made entirely of end stone.
# Surfaces made of purpur represent End Cities, but structures should load in relative to the island's surface, not the top of the End City, so purpur is an invalid target,
# and obsidian and other variants of purpur are invalid as well for our purposes.  Chorus plants are also invalid for our purposes.
# We are looking for end stone as the surface.
# If we do not find end stone, we want about y=63 to be the reference point for all void structures.

# Make sure the armor stand is at the actual surface (not on top of an End City or something).
execute @s ~ ~ ~ detect ~ ~-1 ~ minecraft:end_stone -1 entitydata @s {CustomName:TyrStructure4}

# If the armor stand is still named TyrStructure3 ("Prepare Location"), then its current location did not qualify, so move it down one block, so its ready to check again next tick.
execute @s[name=TyrStructure3] ~ ~ ~ tp @s ~ ~-1 ~

# If the armor stand is in a TyrBiome of type EndVoid (TyrBiome ID 33), then we know there is no qualifying end island nearby, so we should finish the search.
execute @s[score_TyrBiome=33,score_TyrBiome_min=33] ~ ~ ~ entitydata @s {CustomName:TyrStructure4}
execute @s[score_TyrBiome=33,score_TyrBiome_min=33] ~ ~ ~ tp @s ~ 63 ~

# If the armor stand is inside an obsidian tower, then we know this an end island biome (the central End Dragon island), but we won't find end stone here,
# no matter how hard we look, so let's go ahead and end the search, and just assume a y level of 63 for any end island structure to be generated.
execute @s ~ ~ ~ detect ~ ~-1 ~ minecraft:obsidian -1 entitydata @s {CustomName:TyrStructure4}
execute @s ~ ~ ~ detect ~ ~-1 ~ minecraft:obsidian -1 tp @s ~ 63 ~

# If the armor stand is now at the bottom of the world, then there has been some mistake in biome detection and/or there is no endstone here,
# so it won't find an end stone surface at its x and z coordinates, no matter how hard we look,
# so set it back to y=63, and change its name to TyrStructure4 to indicate that the appropriate location has been found.
execute @s ~ ~ ~ detect ~ ~-1 ~ minecraft:barrier -1 entitydata @s {CustomName:TyrStructure4}
execute @s ~ ~ ~ detect ~ ~-1 ~ minecraft:barrier -1 tp @s ~ 63 ~
