#=======================#
# Tyruswoo Game Changer #
# Density Reset         #
#=======================#
# Set the Density to the default density given in the Settings file.
# Note: This function only works if the Game Changer was already started (because the Tyruswoo:Settings file is only "read" when it is run as a function during Game Changer startup).
# (Also, parts of this function only work if at least one player is logged in.)

# Announcement:
tellraw @a [{"text":"Tyruswoo:GameChanger/DensityReset ","color":"aqua"},{"text":"Automatically resetting the Density to the value listed in the Tyruswoo:Settings file...","color":"gray"}]

# Identify the density listed in the Settings file, and apply it.
scoreboard players operation TyrTimer TyrDensity = TyrSettings TyrDensity

# Now the density has been set!  However, we don't know what it is, if we haven't looked at the Settings file!  Let's figure out what the density is.
scoreboard players operation @a TyrDensity = TyrTimer TyrDensity

# Output a message based on the current density.
# Also, if the Tyruswoo:Settings file did not contain a valid Density setting, then set the density to Density2 (Normal), the default recommended setting.
# DENSITY 0 OR LESS:
execute @p[score_TyrDensity=0] ~ ~ ~ tellraw @a [{"text":"Error! No valid Density listed in the Tyruswoo:Settings File. Density will be set to Density2 (Normal), the default recommended setting.","color":"red"}]
execute @p[score_TyrDensity=0] ~ ~ ~ scoreboard players set TyrTimer TyrDensity 2
execute @p[score_TyrDensity=0] ~ ~ ~ tellraw @a [{"text":"Tyruswoo:Density2 ","color":"aqua"},{"text":"Set Structure Density to 2, \"Normal (Recommended)\".","color":"gray"}]
# DENSITY 1
execute @p[score_TyrDensity_min=1,score_TyrDensity=1] ~ ~ ~ tellraw @a [{"text":"Tyruswoo:Density1 ","color":"aqua"},{"text":"Set Structure Density to 1, \"Sparse\", the lowest setting.","color":"gray"}]
# DENSITY 2
execute @p[score_TyrDensity_min=2,score_TyrDensity=2] ~ ~ ~ tellraw @a [{"text":"Tyruswoo:Density2 ","color":"aqua"},{"text":"Set Structure Density to 2, \"Normal (Recommended)\".","color":"gray"}]
# DENSITY 3
execute @p[score_TyrDensity_min=3,score_TyrDensity=3] ~ ~ ~ tellraw @a [{"text":"Tyruswoo:Density3 ","color":"aqua"},{"text":"Set Structure Density to 3, \"Common\".","color":"gray"}]
# DENSITY 4
execute @p[score_TyrDensity_min=4,score_TyrDensity=4] ~ ~ ~ tellraw @a [{"text":"Tyruswoo:Density4 ","color":"aqua"},{"text":"Set Structure Generator's Density to 4, \"Extremely Abundant\".","color":"gray"}]
# DENSITY 5 OR HIGHER:
execute @p[score_TyrDensity_min=5] ~ ~ ~ tellraw @a [{"text":"Error! No valid Density listed in the Tyruswoo:Settings File. Density will be set to Density2 (Normal), the default recommended setting.","color":"red"}]
execute @p[score_TyrDensity_min=5] ~ ~ ~ scoreboard players set TyrTimer TyrDensity 2
execute @p[score_TyrDensity_min=5] ~ ~ ~ tellraw @a [{"text":"Tyruswoo:Density2 ","color":"aqua"},{"text":"Set Structure Density to 2, \"Normal (Recommended)\".","color":"gray"}]
