#=======================#
# Tyruswoo Game Changer #
# Density               #
#=======================#
# If the Game Changer has already been started, but it does not yet have a density setting,
# then this function will be called to provide a default density based on the Settings file.
# (Only works if at least one player is logged in.)

# First, we make sure that if the density was not set, and therefore is still zero, it will recognize that it is zero.
# We do this by adding 1, then subtracting 1.
scoreboard players add TyrTimer TyrDensity 1
scoreboard players remove TyrTimer TyrDensity 1

# Let's check whether TyrTimer has been given a density value higher than zero.  If not, we will need to set its density.
scoreboard players operation @a TyrDensity = TyrTimer TyrDensity
execute @p[score_TyrDensity_min=0,score_TyrDensity=0] ~ ~ ~ tellraw @a [{"text":"Density has not yet been set. Automatically calling Tyruswoo:GameChanger/DensityReset to set the density according to the settings in the Tyruswoo:Settings file...","color":"gray"}]
execute @p[score_TyrDensity_min=0,score_TyrDensity=0] ~ ~ ~ function Tyruswoo:GameChanger/DensityReset
