#====================================#
#         Game Changer: Clock        #
#            by Tyruswoo             #
#                                    #
#         For Minecraft 1.12         #
#====================================#

# Clock 4: Fast
# Only use this clock in Single Player. Not recommended for servers.
# In multiplayer servers, this clock will likely cause noticeable lag during fights with enemy mobs.
# When exploring new areas, structures will generate within only a few seconds.  There is also an extra boost to how fast structure locations are prepared/found.

# This clock is designed to be used as the Game Loop Function, or to be called each tick of the Game Loop Function.
# It is essentially a timer clock that increases each game tick and runs functions at certain times, then resets.
# This distributes commands over a longer time period, resulting in less lag, yet still with fast structure generation.

# Timer
execute @p ~ ~ ~ scoreboard players add TyrTimer TyrClock 1
scoreboard players operation @a TyrClock = TyrTimer TyrClock

#====================================================================================================================
# Run These Functions Multiple Times Per Cycle of the Clock

# Prepare the locations for structures to be generated.
execute @p ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/PrepareLocations
execute @p ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/PrepareLocations

#====================================================================================================================
# Run These Functions at Certain Times

# SCAN: Scan the world for dimension and biome, and pseudorandom density check to determine if structure is needed, based on density setting.
execute @p[score_TyrClock_min=1,score_TyrClock=1] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/PrepareForExpand
execute @p[score_TyrClock_min=2,score_TyrClock=2] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/ExpandNorth
execute @p[score_TyrClock_min=3,score_TyrClock=3] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/ExpandEast
execute @p[score_TyrClock_min=4,score_TyrClock=4] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/ExpandSouth
execute @p[score_TyrClock_min=5,score_TyrClock=5] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/ExpandWest
execute @p[score_TyrClock_min=6,score_TyrClock=6] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/ExpandCleanMark
execute @p[score_TyrClock_min=10,score_TyrClock=10] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/CleanAfterExpand
execute @p[score_TyrClock_min=11,score_TyrClock=11] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/New
execute @p[score_TyrClock_min=12,score_TyrClock=12] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/CleanMark
execute @p[score_TyrClock_min=13,score_TyrClock=13] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/CleanEntities
execute @p[score_TyrClock_min=14,score_TyrClock=14] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/DetectDimension
execute @p[score_TyrClock_min=19,score_TyrClock=19] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/DensityCheck
execute @p[score_TyrClock_min=20,score_TyrClock=20] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/DetectBiome
execute @p[score_TyrClock_min=21,score_TyrClock=21] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/MarkBiome

# RANDOM: Select a random structure. Requires emeraldfyr3's math library, available at https://www.youtube.com/watch?v=Are2XbCGrnk
execute @p[score_TyrClock_min=26,score_TyrClock=26] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Random/SetLowerBound
execute @p[score_TyrClock_min=27,score_TyrClock=27] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Random/SetUpperBound
execute @p[score_TyrClock_min=28,score_TyrClock=28] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Random/GetRandomNumber
execute @p[score_TyrClock_min=29,score_TyrClock=29] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Random/AssignRandomNumber

# LOAD: For each passing density check, load structures into the their respective locations for biomes of each dimension.
execute @p[score_TyrClock_min=30,score_TyrClock=30] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/Clean
execute @p[score_TyrClock_min=31,score_TyrClock=31] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/SpreadStructures
execute @p[score_TyrClock_min=33,score_TyrClock=33] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/PlaceStructures
execute @p[score_TyrClock_min=34,score_TyrClock=34] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/UnpackStructures

# SCATTER: Special loading for scatter structures.
execute @p[score_TyrClock_min=40,score_TyrClock=40] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/DetectDimension
execute @p[score_TyrClock_min=42,score_TyrClock=42] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/PrepEndLocation
execute @p[score_TyrClock_min=43,score_TyrClock=43] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/PlaceStructures
execute @p[score_TyrClock_min=44,score_TyrClock=44] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/UnpackStructures

# RULES: Make sure no players are cheating by walking on the barrier block layer marking the completion of End generation.
execute @p[score_TyrClock_min=50,score_TyrClock=50] ~ ~ ~ function Tyruswoo:Settings/Rules

#====================================================================================================================
# Reset Timer
execute @p[score_TyrClock_min=50] ~ ~ ~ scoreboard players set TyrTimer TyrClock 0
