#====================================#
#         Game Changer: Clock        #
#            by Tyruswoo             #
#                                    #
#         For Minecraft 1.12         #
#====================================#

# Clock 2: Safe (Recommended for Minecraft Servers)
# Recommended for servers with plenty of RAM allotted to Minecraft.
# Completes a cycle in about 500 ticks, or about 25 seconds.
# When exploring a new area, it could take a few minutes for structures to load in.
# Clock 2 is recommended for servers, but servers with plenty of RAM (and lots of exploring, but rarely fighting mobs) may also consider using Clock 3 (Balanced).
# To allot more RAM to Minecraft in Windows, you can create a batch file. Please ask Tyruswoo (or a computer scientist) for technical assistance if you need any help with this.

# This clock is designed to be used as the Game Loop Function, or to be called each tick of the Game Loop Function.
# It is essentially a timer clock that increases each game tick and runs functions at certain times, then resets.
# This distributes commands over a longer time period, resulting in less lag, yet still with fast structure generation.

# Timer
execute @p ~ ~ ~ scoreboard players add TyrTimer TyrClock 1
scoreboard players operation @a TyrClock = TyrTimer TyrClock

#====================================================================================================================
# Run These Functions Multiple Times Per Cycle of the Clock

# Prepare the locations for structures to be generated.
execute @p[score_TyrClock_min=70,score_TyrClock=70] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/PrepareLocations
execute @p[score_TyrClock_min=80,score_TyrClock=80] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/PrepareLocations
execute @p[score_TyrClock_min=150,score_TyrClock=150] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/PrepareLocations
execute @p[score_TyrClock_min=160,score_TyrClock=160] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/PrepareLocations
execute @p[score_TyrClock_min=220,score_TyrClock=220] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/PrepareLocations
execute @p[score_TyrClock_min=230,score_TyrClock=230] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/PrepareLocations
execute @p[score_TyrClock_min=350,score_TyrClock=350] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/PrepareLocations
execute @p[score_TyrClock_min=360,score_TyrClock=360] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/PrepareLocations
execute @p[score_TyrClock_min=450,score_TyrClock=450] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/PrepareLocations
execute @p[score_TyrClock_min=460,score_TyrClock=460] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/PrepareLocations

#====================================================================================================================
# Run These Functions at Certain Times

# SCAN: Scan the world for dimension and biome, and pseudorandom density check to determine if structure is needed, based on density setting.
execute @p[score_TyrClock_min=10,score_TyrClock=10] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/PrepareForExpand
execute @p[score_TyrClock_min=20,score_TyrClock=20] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/ExpandNorth
execute @p[score_TyrClock_min=30,score_TyrClock=30] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/ExpandEast
execute @p[score_TyrClock_min=40,score_TyrClock=40] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/ExpandSouth
execute @p[score_TyrClock_min=50,score_TyrClock=50] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/ExpandWest
execute @p[score_TyrClock_min=60,score_TyrClock=60] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/ExpandCleanMark
execute @p[score_TyrClock_min=100,score_TyrClock=100] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/CleanAfterExpand
execute @p[score_TyrClock_min=110,score_TyrClock=110] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/New
execute @p[score_TyrClock_min=120,score_TyrClock=120] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/CleanMark
execute @p[score_TyrClock_min=130,score_TyrClock=130] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/CleanEntities
execute @p[score_TyrClock_min=140,score_TyrClock=140] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/DetectDimension
execute @p[score_TyrClock_min=190,score_TyrClock=190] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/DensityCheck
execute @p[score_TyrClock_min=200,score_TyrClock=200] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/DetectBiome
execute @p[score_TyrClock_min=210,score_TyrClock=210] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/MarkBiome

# RANDOM: Select a random structure. Requires emeraldfyr3's math library, available at https://www.youtube.com/watch?v=Are2XbCGrnk
execute @p[score_TyrClock_min=260,score_TyrClock=260] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Random/SetLowerBound
execute @p[score_TyrClock_min=270,score_TyrClock=270] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Random/SetUpperBound
execute @p[score_TyrClock_min=280,score_TyrClock=280] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Random/GetRandomNumber
execute @p[score_TyrClock_min=290,score_TyrClock=290] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Random/AssignRandomNumber

# LOAD: For each passing density check, load structures into the their respective locations for biomes of each dimension.
execute @p[score_TyrClock_min=300,score_TyrClock=300] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/Clean
execute @p[score_TyrClock_min=310,score_TyrClock=310] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/SpreadStructures
execute @p[score_TyrClock_min=330,score_TyrClock=330] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/PlaceStructures
execute @p[score_TyrClock_min=340,score_TyrClock=340] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/UnpackStructures

# SCATTER: Special loading for scatter structures.
execute @p[score_TyrClock_min=400,score_TyrClock=400] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/DetectDimension
execute @p[score_TyrClock_min=420,score_TyrClock=420] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/PrepEndLocation
execute @p[score_TyrClock_min=430,score_TyrClock=430] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/PlaceStructures
execute @p[score_TyrClock_min=440,score_TyrClock=440] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/UnpackStructures

# RULES: Make sure no players are cheating by walking on the barrier block layer marking the completion of End generation.
execute @p[score_TyrClock_min=500,score_TyrClock=500] ~ ~ ~ function Tyruswoo:Settings/Rules

#====================================================================================================================
# Reset Timer
execute @p[score_TyrClock_min=500] ~ ~ ~ scoreboard players set TyrTimer TyrClock 0
