#====================================#
#         Game Changer: Clock        #
#            by Tyruswoo             #
#                                    #
#         For Minecraft 1.12         #
#====================================#

# Clock 1: Ultra Safe
# Use this clock only if the other clocks failed to work.
# If you are considering this clock, you probably need to make sure your computer is allotting enough of its RAM to running Minecraft.
# To allot more RAM to Minecraft on Windows, you can use a batch file.
# If you allot more RAM to Minecraft, then you probably won't need to try this Ultra Safe clock.
# In other words, if you are considering this Ultra Safe clock, then the Tyruswoo Game Changer is probably not the main thing that needs to be fixed.
# Once you have more RAM being allotted to Minecraft, then you can probably run the Tyruswoo Game Changer using Clock 3 (Balanced) or Clock 2 (Safe).

# Clock 1 (Ultra Safe) is good for Minecraft servers that cannot run the Game Changer using any other clock.
# Structures will load in within about 15 minutes to 1 hour of exploring a new area.
# This clock generates less lag than the other clocks, as it is doing things more slowly; however, it still needs to count time every tick, so it always requires processing.
# For this reason, the Ultra Safe clock, despite being much slower, actually is only marginally safer than the Safe clock.

# This clock is designed to be used as the Game Loop Function, or to be called each tick of the Game Loop Function.
# It is essentially a timer clock that increases each game tick and runs functions at certain times, then resets.
# This distributes commands over a longer time period, resulting in less lag, yet still with structure generation.

# Timer
execute @p ~ ~ ~ scoreboard players add TyrTimer TyrClock 1
scoreboard players operation @a TyrClock = TyrTimer TyrClock

#====================================================================================================================
# Run These Functions Multiple Times Per Cycle of the Clock

# Prepare the locations for structures to be generated.
execute @p[score_TyrClock_min=700,score_TyrClock=700] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/PrepareLocations
execute @p[score_TyrClock_min=800,score_TyrClock=800] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/PrepareLocations
execute @p[score_TyrClock_min=2200,score_TyrClock=2200] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/PrepareLocations
execute @p[score_TyrClock_min=2300,score_TyrClock=2300] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/PrepareLocations
execute @p[score_TyrClock_min=3500,score_TyrClock=3500] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/PrepareLocations
execute @p[score_TyrClock_min=3600,score_TyrClock=3600] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/PrepareLocations
execute @p[score_TyrClock_min=4500,score_TyrClock=4500] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/PrepareLocations
execute @p[score_TyrClock_min=4600,score_TyrClock=4600] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/PrepareLocations

#====================================================================================================================
# Run These Functions at Certain Times

# SCAN: Scan the world for dimension and biome, and pseudorandom density check to determine if structure is needed, based on density setting.
execute @p[score_TyrClock_min=100,score_TyrClock=100] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/PrepareForExpand
execute @p[score_TyrClock_min=200,score_TyrClock=200] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/ExpandNorth
execute @p[score_TyrClock_min=300,score_TyrClock=300] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/ExpandEast
execute @p[score_TyrClock_min=400,score_TyrClock=400] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/ExpandSouth
execute @p[score_TyrClock_min=500,score_TyrClock=500] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/ExpandWest
execute @p[score_TyrClock_min=600,score_TyrClock=600] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/ExpandCleanMark
execute @p[score_TyrClock_min=1000,score_TyrClock=1000] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/CleanAfterExpand
execute @p[score_TyrClock_min=1100,score_TyrClock=1100] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/New
execute @p[score_TyrClock_min=1200,score_TyrClock=1200] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/CleanMark
execute @p[score_TyrClock_min=1300,score_TyrClock=1300] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/CleanEntities
execute @p[score_TyrClock_min=1400,score_TyrClock=1400] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/DetectDimension
execute @p[score_TyrClock_min=1900,score_TyrClock=1900] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/DensityCheck
execute @p[score_TyrClock_min=2000,score_TyrClock=2000] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/DetectBiome
execute @p[score_TyrClock_min=2100,score_TyrClock=2100] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scan/MarkBiome

# RANDOM: Select a random structure. Requires emeraldfyr3's math library, available at https://www.youtube.com/watch?v=Are2XbCGrnk
execute @p[score_TyrClock_min=2600,score_TyrClock=2600] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Random/SetLowerBound
execute @p[score_TyrClock_min=2700,score_TyrClock=2700] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Random/SetUpperBound
execute @p[score_TyrClock_min=2800,score_TyrClock=2800] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Random/GetRandomNumber
execute @p[score_TyrClock_min=2900,score_TyrClock=2900] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Random/AssignRandomNumber

# LOAD: For each passing density check, load structures into the their respective locations for biomes of each dimension.
execute @p[score_TyrClock_min=3000,score_TyrClock=3000] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/Clean
execute @p[score_TyrClock_min=3100,score_TyrClock=3100] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/SpreadStructures
execute @p[score_TyrClock_min=3300,score_TyrClock=3300] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/PlaceStructures
execute @p[score_TyrClock_min=3400,score_TyrClock=3400] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Load/UnpackStructures

# SCATTER: Special loading for scatter structures.
execute @p[score_TyrClock_min=4000,score_TyrClock=4000] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/DetectDimension
execute @p[score_TyrClock_min=4200,score_TyrClock=4200] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/PrepEndLocation
execute @p[score_TyrClock_min=4300,score_TyrClock=4300] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/PlaceStructures
execute @p[score_TyrClock_min=4400,score_TyrClock=4400] ~ ~ ~ function Tyruswoo:GameChanger/StructureGenerator/Scatter/UnpackStructures

# RULES: Make sure no players are cheating by walking on the barrier block layer marking the completion of End generation.
execute @p[score_TyrClock_min=50,score_TyrClock=50] ~ ~ ~ function Tyruswoo:Settings/Rules
execute @p[score_TyrClock_min=550,score_TyrClock=550] ~ ~ ~ function Tyruswoo:Settings/Rules
execute @p[score_TyrClock_min=1050,score_TyrClock=1050] ~ ~ ~ function Tyruswoo:Settings/Rules
execute @p[score_TyrClock_min=1550,score_TyrClock=1550] ~ ~ ~ function Tyruswoo:Settings/Rules
execute @p[score_TyrClock_min=2050,score_TyrClock=2050] ~ ~ ~ function Tyruswoo:Settings/Rules
execute @p[score_TyrClock_min=2550,score_TyrClock=2550] ~ ~ ~ function Tyruswoo:Settings/Rules
execute @p[score_TyrClock_min=3050,score_TyrClock=3050] ~ ~ ~ function Tyruswoo:Settings/Rules
execute @p[score_TyrClock_min=3550,score_TyrClock=3550] ~ ~ ~ function Tyruswoo:Settings/Rules
execute @p[score_TyrClock_min=4050,score_TyrClock=4050] ~ ~ ~ function Tyruswoo:Settings/Rules
execute @p[score_TyrClock_min=4550,score_TyrClock=4550] ~ ~ ~ function Tyruswoo:Settings/Rules

#====================================================================================================================
# Reset Timer
execute @p[score_TyrClock_min=5000] ~ ~ ~ scoreboard players set TyrTimer TyrClock 0
