
import copy

header = """
{
  "type": "minecraft:entity",
  "pools": [
    {
      "rolls": 1,
      "entries": [
        {
          "type": "minecraft:item",
          "name": "minecraft:written_book",
          "functions": [
            {
              "function": "minecraft:set_name",
              "name": {"translate":"mech.item.mechanical_manual","color":"gray","italic":false}
            },
            {
              "function": "minecraft:set_lore",
              "lore": [
                {"translate":"mech.lore.added_by","color":"blue","italic":false}
              ]
            },
            {
              "function": "minecraft:set_nbt",
              "tag":"{mech_itemid: 1105, CustomModelData: 6421105, HideFlags: 32, author:\\"ImCoolYeah105\\", title:\\"Mechanical Manual\\", mech_version:4 }"
            },
            {
              "function": "minecraft:set_nbt",
              "tag":"{pages:[
"""
footer = """
]}"
            }
          ]
        }
      ]
    }
  ]
}

"""

pin_recipe_footer = """

#set data
data remove block -29999999 0 1601 Items
data modify block -29999999 0 1601 Items append from entity @s SelectedItem
data modify block -29999999 0 1601 Items[0].Slot set value 0b
data modify block -29999999 0 1601 Items[0].tag.display.Lore set from storage du:temp list
data modify block -29999999 0 1601 Items[0].tag.display.Lore append value '{"translate":"mech.lore.added_by","color":"blue","italic":false}'
item replace entity @s weapon.mainhand from block -29999999 0 1601 container.0
"""

#json text constructors
class json_text:
    def __init__(self, string, translate=False, bold=None, underline=None, font=None, color=None, extra=[]):
        self.string = string
        self.translate = translate
        self.font = font
        self.color = color
        self.extra = extra
        self.bold = bold
        self.underline = underline
    
    def getJson(self):
        out = ''
        if self.translate:
            out = f'{{"translate":"{self.string}"'
        else:
            out =  f'{{"text":"{self.string}"'

        if self.bold != None:
            out += f',"bold":{str(self.bold).lower()}'
        if self.underline != None:
            out += f',"underlined":{str(self.underline).lower()}'
        if self.font != None:
            out += f',"font":"{self.font}"'
        if self.color != None:
            out += f',"color":"{self.color}"'

        for extra in self.extra:
            out += extra.getJson()
        return out + '}'
class json_score:
    def __init__(self, selector, objective, bold=None, font=None, color=None, extra=[]):
        self.selector = selector
        self.objective = objective
        self.font = font
        self.color = color
        self.extra = extra
        self.bold = bold
    
    def getJson(self):
        out = f'{{"score":{{"name":"{self.selector}","objective":"{self.objective}"}}'

        if self.bold != None:
            out += f',"bold":{str(self.bold).lower()}'
        if self.font != None:
            out += f',"font":"{self.font}"'
        if self.color != None:
            out += f',"color":"{self.color}"'

        for extra in self.extra:
            out += extra.getJson()
        return out + '}'
class json_hover_component:
    def __init__(self, contents=[]):
        self.contents = contents
    
    def getJson(self):
        out =  f',"hoverEvent":{{"action":"show_text","contents":[ '
        for content in self.contents:
            out += content.getJson() + ','
        return out[0:-1] + ']}'
class json_with:
    def __init__(self, contents=[]):
        self.contents = contents
    
    def getJson(self):
        out =  f',"with":[ '
        for content in self.contents:
            out += content.getJson() + ','
        return out[0:-1] + ']'
class json_open_webpage:
    def __init__(self, string):
        self.string = string
    
    def getJson(self):
        return  f',"clickEvent":{{"action":"open_url","value":"{self.string}"}}'
class json_run_command:
    def __init__(self, string):
        self.string = string
    
    def getJson(self):
        return  f',"clickEvent":{{"action":"run_command","value":"{self.string}"}}'
class json_switch_page:
    def __init__(self, page):
        self.page = page
    
    def getJson(self):
        return  f',"clickEvent":{{"action":"change_page","value":{self.page}}}'

#page constructors
class blank_page:
    def __init__(self, title=None, body=None):
        self.title = title
        self.body = body

    def getJson(self):
        out = "'[]'"
        if self.title != None and self.body != None:
            newline = json_text(string='\\n')
            out = f"'[{json_text('',color='black',font='mechanization:manual',bold=False).getJson()},{self.title.getJson()},{newline.getJson()},{self.body.getJson()}]'"
        elif self.title != None:
            out = f"'[{json_text('',color='black',font='mechanization:manual',bold=False).getJson()},{self.title.getJson()}]'"
        elif self.body != None:
            out = f"'[{json_text('',color='black',font='mechanization:manual',bold=False).getJson()},{self.body.getJson()}]'"
        return out.replace('"','\\"')
class default_page:
    def __init__(self, title, starting_icon, recipe_id=-1, ingredients=[]):
        self.title = title
        self.id = recipe_id
        self.ingredients = ingredients

        icon = int(starting_icon, 16)
        self.icon = f'\\u{hex(icon)[2:]}'
        if recipe_id != -1:
            self.recipe1 = f'\\u{hex(icon+1)[2:]}'
            self.recipe2 = f'\\u{hex(icon+2)[2:]}'
        else:
            self.recipe1 = None
            self.recipe2 = None

    def getJson(self):
        out = "'["
        for component in self.getComponents():
            out += component.getJson().replace('"','\\"') + ','
        return out[0:-1] + "]'"

    def getComponents(self):
        out = []
        out.append(json_text(string='',bold=False,color='white',font='mechanization:manual'))
        
        if self.recipe1 == None or self.recipe2 == None or self.id == -1:
            out.append( json_text(string='\\uee02') )
        else:
            out.append( json_text(string='\\uee03',extra=createRecipeContents(self.recipe1,self.recipe2,self.id,self.ingredients)) )
        
        out.append( offset(json_text(string=self.icon),-105) )
        if self.recipe1 != None and self.recipe2 != None and self.id > -1:
            out.append( offset(json_text(string='\\uee04'),47) )
        out.append( json_text(string='\\n') )
        out.append( json_text(string=f'mech.manual.{self.title}.body',color='black',translate=True) )

        out.append( json_text('           ') )
        out.append( json_text(string='\\uee0e',extra=[json_switch_page(2)]) )
        return out
class title_page:
    def getJson(self):
        out = "'["
        for component in self.getComponents():
            out += component.getJson().replace('"','\\"') + ','
        return out[0:-1] + "]'"

    def getComponents(self):
        return [
            json_text(string='\\uee01',font='mechanization:manual',color='white'),
            json_text(string='offset.31',translate=True,font='space:default',extra=[ json_with(contents=[json_text(string='\\uee00',font='mechanization:manual',color='white')]) ]),
            json_text(string='\\n\\n\\n  '),
            json_text(string='   ',extra=[json_open_webpage('https://discord.gg/C8yUMWs'),json_hover_component(contents=[json_text(string='Discord',color="white")])]),
            json_text(string='                   '),
            json_text(string='   ',extra=[json_open_webpage('https://github.com/ICY105/Mechanization'),json_hover_component(contents=[json_text(string='Github',color="white")])]),
            json_text(string='\\n\\n      '),
            json_text(string='mech.text.version',color='dark_purple',translate=True,extra=[json_with(contents=[json_score('$mech.ver.major','load.status',color='dark_purple'),json_score('$mech.ver.minor','load.status',color='dark_purple'),json_score('$mech.ver.fix','load.status',color='dark_purple')])]),
            json_text(string='\\n\\n'),
            json_text(string='mech.manual.title_page',translate=True,color='black')
        ]
class apps_page:
    def getJson(self):
        out = "'["
        for component in self.getComponents():
            out += component.getJson().replace('"','\\"') + ','
        return out[0:-1] + "]'"

    def getComponents(self):
        return [
            json_text(string='\\uee05',color='white',font='mechanization:manual'),
            json_text(string='      '),
            json_text(string='mech.manual.apps_page',translate=True,color='dark_aqua'),
            json_text(string='\\n'),
            json_text(string=' \\uee06'),
            offset(json_text(string='\\uee08',extra=createAppContents('mech.manual.app_base','mech.manual.app_base_desc',-1)),-1),
            offset(json_text(string='\\uee09',extra=createAppContents('mech.manual.app_machines','mech.manual.app_machines_desc',-2)),-2),
            offset(json_text(string='\\uee0a',extra=createAppContents('mech.manual.app_nuclear','mech.manual.app_nuclear_desc',-3)),-3),
            offset(json_text(string='\\uee07'),-4),
            json_text(string='\\n  '),
            json_text(string='        ',extra=createAppContents('mech.manual.app_base','mech.manual.app_base_desc',-1)),
            json_text(string='        ',extra=createAppContents('mech.manual.app_machines','mech.manual.app_machines_desc',-2)),
            json_text(string='        ',extra=createAppContents('mech.manual.app_nuclear','mech.manual.app_nuclear_desc',-3)),
            json_text(string='\\n  '),
            json_text(string='        ',extra=createAppContents('mech.manual.app_base','mech.manual.app_base_desc',-1)),
            json_text(string='        ',extra=createAppContents('mech.manual.app_machines','mech.manual.app_machines_desc',-2)),
            json_text(string='        ',extra=createAppContents('mech.manual.app_nuclear','mech.manual.app_nuclear_desc',-3)),
            json_text(string='\\n'),

            json_text(string=' \\uee06'),
            offset(json_text(string='\\uee0b',extra=createAppContents('mech.manual.app_gadgets','mech.manual.app_gadgets_desc',-4)),-1),
            offset(json_text(string='\\uee0c',extra=createAppContents('mech.manual.app_assembly','mech.manual.app_assembly_desc',-5)),-2),
            offset(json_text(string='\\uee0d',extra=createAppContents('mech.manual.app_tcc','mech.manual.app_tcc_desc',-6)),-3),
            offset(json_text(string='\\uee07'),-4),
            json_text(string='\\n  '),
            json_text(string='        ',extra=createAppContents('mech.manual.app_gadgets','mech.manual.app_gadgets_desc',-4)),
            json_text(string='        ',extra=createAppContents('mech.manual.app_assembly','mech.manual.app_assembly_desc',-5)),
            json_text(string='        ',extra=createAppContents('mech.manual.app_tcc','mech.manual.app_tcc_desc',-6)),
            json_text(string='\\n  '),
            json_text(string='        ',extra=createAppContents('mech.manual.app_gadgets','mech.manual.app_gadgets_desc',-4)),
            json_text(string='        ',extra=createAppContents('mech.manual.app_assembly','mech.manual.app_assembly_desc',-5)),
            json_text(string='        ',extra=createAppContents('mech.manual.app_tcc','mech.manual.app_tcc_desc',-6)),
            json_text(string='\\n'),

            json_text(string=' \\uee06'),
            offset(json_text(string='\\uee16',extra=createAppContents('mech.manual.app_accessory_bag','mech.manual.app_accessory_bag_desc',-7)),-1),
            offset(json_text(string='\\uee07'),-2),
            json_text(string='\\n  '),
            json_text(string='        ',extra=createAppContents('mech.manual.app_accessory_bag','mech.manual.app_accessory_bag_desc',-7)),
            json_text(string='\\n  '),
            json_text(string='        ',extra=createAppContents('mech.manual.app_accessory_bag','mech.manual.app_accessory_bag_desc',-7)),
            json_text(string='\\n'),
        ]
class index_page:
    def __init__(self, title, pages):
        self.pages = pages
        self.title = title

    def getJson(self):
        out = "'["
        for component in self.getComponents():
            out += component.getJson().replace('"','\\"') + ','
        return out[0:-1] + "]'"

    def getComponents(self):
        out = [
            json_text(string='',font='mechanization:manual',color='white'),
            json_text(string='\\uee05'),
            json_text(string=self.title,translate=True,color='dark_aqua'),
            json_text(string='\\n  '),
            json_text(string='\\uee12'),
            json_text(string='\\n')
        ]
        out.append( json_text(string='  ') )
        out.append( json_text(string='\\uee10') )
        
        pos = 0
        temp = []
        for page in self.pages:
            if pos > 4:
                out.append( offset(json_text(string='\\uee11'),-8) )
                out.append( json_text(string='\\n   ') )
                for i in temp:
                    out.append(i)
                temp = []
                out.append( json_text(string='\\n  ') )
                out.append( json_text(string='\\uee10') )
                pos = 0
            pos += 1
            out.append( offset(page, pos * -1) )
            temp_page = copy.deepcopy(page)
            temp_page.string = '\\uee14'
            temp.append( offset(temp_page, pos * -1) )

        while pos < 5:
            pos += 1
            out.append( offset( json_text(string='\\uee15'), pos * -1) )
        
        out.append( offset(json_text(string='\\uee11'),-8) )
        out.append( json_text(string='\\n   ') )
        for i in temp:
            out.append(i)
        out.append( json_text(string='\\n  ') )
        out.append( json_text(string='\\uee13') )
        return out
class upgrades_page:
    def __init__(self, upgrade):
        self.upgrade = upgrade

    def getJson(self):
        out = "'["
        for component in self.getComponents():
            out += component.getJson().replace('"','\\"') + ','
        return out[0:-1] + "]'"

    def getComponents(self):
        out = [
            json_text('',color='black',bold=False,underline=False,font='mechanization:manual'),
            json_text('mech.manual.upgrades_page',translate=True,underline=True),
            json_text('mech.item.machine_upgrade',translate=True,bold=True,color='gray'),json_text(':\\n',color='gray'),
            json_text(f'{self.upgrade}.machine_upgrade',translate=True),
            json_text('mech.item.ender_upgrade',translate=True,bold=True,color='dark_purple'),json_text(':\\n',color='dark_purple'),
            json_text(f'{self.upgrade}.ender_upgrade',translate=True),
            json_text('mech.item.nether_upgrade',translate=True,bold=True,color='dark_red'),json_text(':\\n',color='dark_red'),
            json_text(f'{self.upgrade}.nether_upgrade',translate=True),
        ]
        return out
class alloys_page:
    #recipe = (icon,id,ingredients)
    def __init__(self, recipes=[]):
        self.recipes = []
        for recipe in recipes:
            icon = int(recipe[0], 16)
            self.recipes.append( (f'\\u{hex(icon)[2:]}',f'\\u{hex(icon+1)[2:]}',f'\\u{hex(icon+2)[2:]}',recipe[1],recipe[2]) )

    def getJson(self):
        out = "'["
        for component in self.getComponents():
            out += component.getJson().replace('"','\\"') + ','
        return out[0:-1] + "]'"

    def getComponents(self):
        out = []
        
        if len(self.recipes) <= 3:
            out.append( json_text(string='\\ueea0',color='white',font='mechanization:manual') )
        else:
            out.append( json_text(string='\\ueea1',color='white',font='mechanization:manual') )

        out.append( json_text(string='\\n') )
        for recipe in self.recipes:
            out.append( offset( json_text(string=recipe[0]),10) )
            out.append( offset( json_text(string='\\uee9d',extra=createRecipeContents(recipe[1],recipe[2],recipe[3],recipe[4]) ),71) )
            out.append( json_text(string='\\n\\n\\n\\n') )
        return out
#helper functions
def createRecipeContents(recipe1, recipe2, recipe_id, ingredients):
    hover = json_hover_component(contents=[
            json_text('mech.manual.recipe',translate=True),
            json_text(recipe1,font='mechanization:manual'),
            offset(json_text(recipe2),-2),
            json_text('\\n\\n\\n\\n\\n\\n')
        ])
    for ingredient in ingredients:
        hover.contents.append(ingredient)
    pin_recipe_file.write(f"""execute if score @s mech_manual matches {recipe_id} run data modify storage du:temp list set value ['[{{"text":"\\{recipe1}","color":"white","font":"mechanization:manual","italic":false}},{{"translate":"offset.-2","color":"black","font":"space:default","italic":false,"with":[ {{"text":"\\{recipe2}","color":"white","font":"mechanization:manual"}}]}}]','{{"text":""}}','{{"text":""}}','{{"text":""}}','{{"text":""}}','{{"text":""}}','{{"text":""}}']\n""")
    return [ hover, json_run_command(f'/trigger mech_manual set {recipe_id}') ]
def createAppContents(title, desc, app_id):
    return [ json_hover_component(contents=[ json_text(title,translate=True), json_text('\\n'), json_text(desc,translate=True,color='gray') ]), json_run_command(f'/trigger mech_manual set {app_id}') ]
def createIndexContents(title, page):
    return [ json_hover_component(contents=[ json_text(title,translate=True) ]), json_switch_page(page) ]
def offset(component,amount):
    new_component = copy.deepcopy(component)
    new_component.font = 'mechanization:manual'
    return json_text(string=f'offset.{amount}',translate=True,font='space:default',extra=[ json_with(contents=[new_component]) ])
def write_manual(title, pages):
    f = open(title,'w')
    f.write(header[0:-1])
    for page in pages:
        if page == pages[-1]:
            f.write(page.getJson())
        else:
            f.write(page.getJson() + ',')
    f.write(footer[1:-1])
    f.close()
def create_index_icon(icon, name, page):
    return json_text(string=icon,extra=createIndexContents(f'mech.manual.{name}.title',page))
def createRecipeList(ingredients):
    out = []
    for ingredient in ingredients:
        out.append(json_text(f'\\n x{ingredient[0]} '))
        out.append(json_text(f'{ingredient[1]}',translate=True))
    return out
#track recipes
pin_recipe_file = open('pin_recipe.mcfunction','w')

#starting manual
pages = [
    title_page(),
    default_page('mechanical_manual','ee20',1105),
    apps_page()
]
write_manual('start.json',pages)

#base manual
pages = [
    apps_page(),
    index_page('mech.manual.base_section',[
        create_index_icon('\\uee23','getting_started',3),
        create_index_icon('\\uee24','machine_crafting_table',5),
        create_index_icon('\\uee25','wrench',6),
        create_index_icon('\\uee26','multimeter',7),
        create_index_icon('\\uee27','grid_ids',8),

        create_index_icon('\\uee28','rods',9),
        create_index_icon('\\uee29','tier_1_battery',15),
        create_index_icon('\\uee2a','tier_1_capacitor',20),
        create_index_icon('\\uee2b','tier_1_machine_frame',12),
        create_index_icon('\\uee2c','vial',25),

        create_index_icon('\\uee2d','plates',10),
        create_index_icon('\\uee2e','tier_2_battery',16),
        create_index_icon('\\uee2f','tier_2_capacitor',21),
        create_index_icon('\\uee30','tier_2_machine_frame',13),
        create_index_icon('\\uee31','energy_relay',24),

        create_index_icon('\\uee32','gears',11),
        create_index_icon('\\uee33','tier_3_battery',17),
        create_index_icon('\\uee34','tier_3_capacitor',22),
        create_index_icon('\\uee35','tier_3_machine_frame',14),
        create_index_icon('\\uee36','quantum_battery',18),

        create_index_icon('\\uee37','machine_upgrade',26),
        create_index_icon('\\uee38','ender_upgrade',27),
        create_index_icon('\\uee39','nether_upgrade',28)
    ]),
    blank_page(title=json_text(string='mech.manual.getting_started.title',translate=True,color='dark_aqua'),body=json_text(string='mech.manual.getting_started.body1',translate=True)),
    blank_page(body=json_text(string='mech.manual.getting_started.body2',translate=True)),
    default_page('machine_crafting_table','ee3a',1005,      createRecipeList( [(7,'item.minecraft.copper_ingot'),(1,'block.minecraft.crafting_table'),(1,'block.minecraft.iron_block')] )),
    default_page('wrench','ee3d',1100,                      createRecipeList( [(3,'item.minecraft.iron_ingot'),(1,'item.minecraft.diamond')] )),
    default_page('multimeter','ee40',1101,                  createRecipeList( [(4,'item.minecraft.gold_ingot'),(2,'item.minecraft.copper_ingot'),(2,'item.minecraft.redstone'),(1,'block.minecraft.glass')] )),
    blank_page(title=json_text(string='mech.manual.grid_ids.title',translate=True,color='dark_aqua'),body=json_text(string='mech.manual.grid_ids.body',translate=True)),
    default_page('rods','ee43',1472,                        createRecipeList( [(3,'mech.manual.any_metal')] )),
    default_page('plates','ee46',1470,                      createRecipeList( [(4,'mech.manual.any_metal')] )),
    default_page('gears','ee49',1471,                       createRecipeList( [(5,'mech.manual.any_metal')] )),
    default_page('tier_1_machine_frame','ee70',1007,        createRecipeList( [(4,'block.minecraft.glass'),(3,'mech.rod.iron'),(2,'mech.plate.tin')] )),
    default_page('tier_1_machine_frame','ee73',1008,        createRecipeList( [(4,'block.minecraft.red_stained_glass'),(2,'mech.rod.steel'),(1,'mech.plate.steel'),(1,'mech.plate.structural'),(1,'mech.gear.structural')] )),
    default_page('tier_1_machine_frame','ee76',1009,        createRecipeList( [(4,'block.minecraft.tinted_glass'),(2,'mech.gear.titanium_steel'),(2,'mech.plate.reinforced_structural'),(1,'mech.rod.reinforced_structural')] )),
    default_page('tier_1_battery','ee4c',1000,              createRecipeList( [(4,'block.minecraft.white_wool'),(2,'block.minecraft.redstone_block'),(1,'mech.rod.copper'),(1,'mech.gear.copper'),(1,'mech.resource.machine_frame_tier_1')] )),
    default_page('tier_2_battery','ee4f',1001,              createRecipeList( [(4,'block.minecraft.gray_wool'),(2,'item.minecraft.diamond'),(1,'mech.rod.conductive'),(1,'mech.gear.conductive'),(1,'mech.resource.machine_frame_tier_2')] )),
    default_page('tier_3_battery','ee52',1002,              createRecipeList( [(4,'block.minecraft.purple_wool'),(2,'mech.plate.nether_alloy'),(1,'mech.rod.super_conductive'),(1,'mech.gear.super_conductive'),(1,'mech.resource.machine_frame_tier_3')] )),
    default_page('quantum_battery','ee55',1003,             createRecipeList( [(4,'block.minecraft.black_wool'),(2,'mech.plate.ender_alloy'),(1,'mech.rod.super_conductive'),(1,'mech.gear.super_conductive'),(1,'mech.resource.machine_frame_tier_3')] )),
    upgrades_page('mech.manual.battery'),
    default_page('tier_1_capacitor','ee58',1010,            createRecipeList( [(4,'block.minecraft.white_wool'),(2,'mech.gear.gold'),(2,'mech.plate.copper'),(1,'mech.resource.machine_frame_tier_1')] )),
    default_page('tier_2_capacitor','ee5b',1011,            createRecipeList( [(4,'block.minecraft.gray_wool'),(2,'item.minecraft.emerald'),(2,'mech.plate.conductive'),(1,'mech.resource.machine_frame_tier_2')] )),
    default_page('tier_3_capacitor','ee5e',1012,            createRecipeList( [(4,'block.minecraft.purple_wool'),(2,'mech.plate.nether_alloy'),(2,'mech.plate.super_conductive'),(1,'mech.resource.machine_frame_tier_3')] )),
    upgrades_page('mech.manual.capacitor'),
    default_page('energy_relay','ee61',1004,                createRecipeList( [(4,'mech.rod.conductive'),(3,'block.minecraft.gray_wool'),(1,'mech.gem.crystal_composite'),(1,'mech.resource.machine_frame_tier_2')] )),
    default_page('vial','ee64',1108,                        createRecipeList( [(2,'mech.ingot.steel'),(1,'block.minecraft.glass')] )),
    default_page('machine_upgrade','ee67',1102,             createRecipeList( [(6,'mech.ingot.steel'),(1,'mech.gear.structural'),(1,'mech.gear.conductive'),(1,'mech.gem.crystal_composite')] )),
    default_page('ender_upgrade','ee6a',1103,               createRecipeList( [(4,'mech.gem.crystal_composite'),(2,'mech.rod.titanium_steel'),(1,'mech.gear.ender_alloy'),(1,'mech.plate.super_conductive'),(1,'mech.plate.reinforced_structural')] )),
    default_page('nether_upgrade','ee6d',1104,              createRecipeList( [(4,'mech.gem.crystal_composite'),(2,'mech.rod.titanium_steel'),(1,'mech.gear.nether_alloy'),(1,'mech.plate.super_conductive'),(1,'mech.plate.reinforced_structural')] ))
]
write_manual('base.json',pages)

#machines manual
pages = [
    apps_page(),
    index_page('mech.manual.machines_section',[
        create_index_icon('\\uee23','progression',4),
        create_index_icon('\\uee79','steam_generator',6),
        create_index_icon('\\uee7a','alloy_furnace',8),
        create_index_icon('\\uee7b','tier_2_alloys',10),
        create_index_icon('\\uee7c','tier_3_alloys',11),

        create_index_icon('\\uee7d','liquid_pipe',13),
        create_index_icon('\\uee7e','thermoelectric_generator',17),
        create_index_icon('\\uee7f','arc_furnace',20),
        create_index_icon('\\uee80','casting_basin',22),
        create_index_icon('\\uef1b','liquid_accumulator',24),

        create_index_icon('\\uee82','tier_1_liquid_tank',14),
        create_index_icon('\\uee81','electric_furnace',25),
        create_index_icon('\\uee83','tree_feller',27),
        create_index_icon('\\uee84','growth_accelerator',29),
        create_index_icon('\\uee86','grinder',33),

        create_index_icon('\\uee87','tier_2_liquid_tank',15),
        create_index_icon('\\uee85','block_breaker',31),
        create_index_icon('\\uee88','solar_panel',35),
        create_index_icon('\\uee89','bio_generator',37),
        create_index_icon('\\uee8a','quarry',41),

        create_index_icon('\\uee8c','tier_3_liquid_tank',16),
        create_index_icon('\\uee8b','auto_farm',43),
        create_index_icon('\\uee8d','auto_fisher',45),
        create_index_icon('\\uee8e','item_reformer',47),
        create_index_icon('\\uee8f','mob_grinder',49)
    ]),
    index_page('mech.manual.machines_section',[
        create_index_icon('\\uee90','electric_lamp',51),
        create_index_icon('\\uee91','super_piston',52),
        create_index_icon('\\uee92','super_sticky_piston',53),
        create_index_icon('\\uee93','turn_table',54),
        create_index_icon('\\uee94','dimensional_generator',55),

        create_index_icon('\\uee95','lightning_generator',60),
        create_index_icon('\\uee96','teleporter',62),
        create_index_icon('\\uee97','enchanting_station',64),
        create_index_icon('\\uee98','spawner_controller',66),
        create_index_icon('\\uee99','spawner_mover',68)
    ]),
    blank_page(title=json_text(string='mech.manual.progression.title',translate=True,color='dark_aqua'),body=json_text(string='mech.manual.progression.body1',translate=True)),
    blank_page(body=json_text(string='mech.manual.progression.body2',translate=True)),
    default_page('steam_generator','ee9a',2001,     createRecipeList( [(4,'block.minecraft.terracotta'),(2,'mech.gear.copper'),(1,'item.minecraft.bucket'),(1,'block.minecraft.furnace'),(1,'mech.resource.machine_frame_tier_1')] )),
    upgrades_page('mech.manual.steam_generator'),
    default_page('alloy_furnace','ee9d',2000,       createRecipeList( [(4,'block.minecraft.bricks'),(2,'mech.plate.copper'),(1,'block.minecraft.redstone_block'),(1,'block.minecraft.blast_furnace'),(1,'mech.resource.machine_frame_tier_1')] )),
    upgrades_page('mech.manual.alloy_furnace'),
    alloys_page([
        ('eea2',1330,createRecipeList([(2,'item.minecraft.flint'),(4,'mech.liquid.molten_coal'),(2,'mech.liquid.molten_iron')])),
        ('eea5',1340,createRecipeList([(4,'item.minecraft.lapis_lazuli'),(2,'mech.liquid.molten_tin'),(4,'mech.liquid.molten_quartz')])),
        ('eea8',1350,createRecipeList([(16,'item.minecraft.redstone'),(4,'mech.liquid.molten_copper'),(2,'mech.liquid.molten_gold')])),
        ('eeab',1410,createRecipeList([(2,'item.minecraft.amethyst_shard'),(2,'mech.liquid.molten_diamond'),(2,'mech.liquid.molten_emerald')]))
    ]),
    alloys_page([
        ('eeae',1360,createRecipeList([(4,'item.minecraft.blaze_rod'),(1,'mech.liquid.molten_titanium'),(2,'mech.liquid.molten_steel')])),
        ('eeb1',1370,createRecipeList([(4,'item.minecraft.prismarine_crystals'),(1,'mech.liquid.molten_titanium'),(2,'mech.liquid.molten_structural_alloy')])),
        ('eeb4',1380,createRecipeList([(4,'item.minecraft.ender_pearl'),(1,'mech.liquid.molten_titanium'),(2,'mech.liquid.molten_conductive_alloy')]))
    ]),
    alloys_page([
        ('eeb7',1390,createRecipeList([(32,'item.minecraft.dragon_breath'),(32,'item.minecraft.chorus_fruit'),(4,'mech.liquid.molten_titanium')])),
        ('eeba',1400,createRecipeList([(1,'item.minecraft.nether_star'),(4,'mech.liquid.molten_titanium'),(4,'block.minecraft.lava')])),
        ('eebe',100,createRecipeList([(4,'item.minecraft.netherite_scrap'),(4,'mech.liquid.molten_gold')]))
    ]),
    default_page('liquid_pipe','eec1',2026,                         createRecipeList( [(2,'mech.plate.copper'),(1,'mech.gear.iron')] )),
    default_page('tier_1_liquid_tank','eec4',2023,                  createRecipeList( [(4,'block.minecraft.oak_log'),(2,'block.minecraft.glass'),(2,'mech.plate.iron'),(1,'mech.resource.machine_frame_tier_1')] )),
    default_page('tier_2_liquid_tank','eec7',2024,                  createRecipeList( [(4,'block.minecraft.nether_bricks'),(2,'block.minecraft.red_stained_glass'),(2,'mech.plate.steel'),(1,'mech.resource.machine_frame_tier_2')] )),
    default_page('tier_3_liquid_tank','eeca',2025,                  createRecipeList( [(4,'block.minecraft.tinted_glass'),(2,'mech.plate.titanium_steel'),(1,'mech.ingot.nether_alloy'),(1,'mech.ingot.ender_alloy'),(1,'mech.resource.machine_frame_tier_3')] )),
    default_page('thermoelectric_generator','eecd',2030,            createRecipeList( [(2,'item.minecraft.redstone'),(2,'item.minecraft.bucket'),(2,'mech.gear.copper'),(2,'mech.gear.gold'),(1,'mech.resource.machine_frame_tier_1')] )),
    upgrades_page('mech.manual.thermoelectric_generator'),
    blank_page(title=json_text(string='mech.manual.liquid_temps.title',translate=True,color='dark_aqua'),body=json_text(string='mech.manual.liquid_temps.body',translate=True)),
    default_page('arc_furnace','eed0',2027,                         createRecipeList( [(4,'block.minecraft.magma_block'),(2,'mech.plate.copper'),(1,'mech.plate.gold'),(1,'block.minecraft.blast_furnace'),(1,'mech.resource.machine_frame_tier_1')] )),
    upgrades_page('mech.manual.arc_furnace'),
    default_page('casting_basin','eed3',2028,                       createRecipeList( [(4,'block.minecraft.smooth_stone'),(2,'mech.rod.copper'),(1,'item.minecraft.redstone'),(1,'block.minecraft.cauldron'),(1,'mech.resource.machine_frame_tier_1')] )),
    upgrades_page('mech.manual.casting_basin'),
    default_page('liquid_accumulator','ef18',2029,                  createRecipeList( [(4,'mech.plate.copper'),(2,'mech.gear.iron'),(1,'item.minecraft.bucket'),(1,'block.minecraft.dispenser'),(1,'mech.resource.machine_frame_tier_1')] )),
    default_page('electric_furnace','eed6',2003,                    createRecipeList( [(4,'item.minecraft.iron_ingot'),(2,'mech.rod.copper'),(1,'mech.gear.gold'),(1,'block.minecraft.blast_furnace'),(1,'mech.resource.machine_frame_tier_1')] )),
    upgrades_page('mech.manual.electric_furnace'),
    default_page('tree_feller','eed9',2002,                         createRecipeList( [(4,'block.minecraft.oak_log'),(2,'item.minecraft.diamond_axe'),(1,'item.minecraft.redstone'),(1,'mech.plate.copper'),(1,'mech.resource.machine_frame_tier_1')] )),
    upgrades_page('mech.manual.tree_feller'),
    default_page('growth_accelerator','eedc',2004,                  createRecipeList( [(4,'block.minecraft.bone_block'),(2,'mech.gear.copper'),(2,'mech.plate.gold'),(1,'mech.resource.machine_frame_tier_1')] )),
    upgrades_page('mech.manual.growth_accelerator'),
    default_page('block_breaker','eedf',2008,                       createRecipeList( [(4,'item.minecraft.copper_ingot'),(1,'item.minecraft.golden_sword'),(1,'item.minecraft.golden_pickaxe'),(1,'item.minecraft.golden_axe'),(1,'item.minecraft.golden_shovel'),(1,'mech.resource.machine_frame_tier_1')] )),
    upgrades_page('mech.manual.block_breaker'),
    default_page('grinder','eee2',2009,                             createRecipeList( [(4,'block.minecraft.obsidian'),(2,'item.minecraft.diamond'),(1,'mech.plate.gold'),(1,'mech.gear.copper'),(1,'mech.resource.machine_frame_tier_1')] )),
    upgrades_page('mech.manual.grinder'),
    default_page('solar_panel','eee5',2014,                         createRecipeList( [(4,'mech.rod.conductive'),(3,'block.minecraft.blue_stained_glass'),(1,'block.minecraft.daylight_detector'),(1,'mech.resource.machine_frame_tier_2')] )),
    upgrades_page('mech.manual.solar_panel'),
    default_page('bio_generator','eee8',2007,                       createRecipeList( [(4,'block.minecraft.nether_bricks'),(2,'mech.plate.conductive'),(1,'block.minecraft.hopper'),(1,'block.minecraft.smoker'),(1,'mech.resource.machine_frame_tier_2')] )),
    upgrades_page('mech.manual.bio_generator'),
    blank_page(title=json_text(string='mech.manual.bio_fuels.title',translate=True,color='dark_aqua'),body=json_text(string='mech.manual.bio_fuels.body1',translate=True)),
    blank_page(body=json_text(string='mech.manual.bio_fuels.body2',translate=True)),
    default_page('quarry','eeeb',2013,                              createRecipeList( [(2,'mech.gem.crystal_composite'),(2,'mech.gear.conductive'),(1,'item.minecraft.diamond_sword'),(1,'item.minecraft.diamond_pickaxe'),(1,'item.minecraft.diamond_axe'),(1,'item.minecraft.diamond_shovel'),(1,'mech.resource.machine_frame_tier_2')] )),
    upgrades_page('mech.manual.quarry'),
    default_page('auto_farm','eeee',2005,                           createRecipeList( [(2,'mech.gem.crystal_composite'),(2,'block.minecraft.piston'),(2,'mech.plate.conductive'),(2,'item.minecraft.diamond_hoe'),(1,'mech.resource.machine_frame_tier_2')] )),
    upgrades_page('mech.manual.auto_farm'),
    default_page('auto_fisher','eef1',2006,                         createRecipeList( [(4,'item.minecraft.fishing_rod'),(2,'item.minecraft.string'),(2,'mech.gear.conductive'),(1,'mech.resource.machine_frame_tier_2')] )),
    upgrades_page('mech.manual.auto_fisher'),
    default_page('item_reformer','eef4',2010,                       createRecipeList( [(4,'mech.gem.crystal_composite'),(2,'mech.gear.conductive'),(1,'mech.manual.mending_book'),(1,'block.minecraft.anvil'),(1,'mech.resource.machine_frame_tier_2')] )),
    upgrades_page('mech.manual.item_reformer'),
    default_page('mob_grinder','eef7',2012,                         createRecipeList( [(2,'item.minecraft.diamond_sword'),(2,'mech.plate.conductive'),(1,'block.minecraft.wither_skeleton_skull'),(1,'item.minecraft.bucket'),(1,'mech.resource.machine_frame_tier_2')] )),
    upgrades_page('mech.manual.mob_grinder'),
    default_page('electric_lamp','eefa',2032,                       createRecipeList( [(4,'item.minecraft.glow_ink_sac'),(2,'block.minecraft.redstone_lamp'),(2,'mech.rod.conductive'),(1,'mech.resource.machine_frame_tier_2')] )),
    default_page('super_piston','eefd',2020,                        createRecipeList( [(4,'mech.ingot.steel'),(3,'block.minecraft.piston'),(2,'block.minecraft.redstone_block')] )),
    default_page('super_sticky_piston','ef00',2021,                 createRecipeList( [(1,'block.minecraft.slime_block'),(1,'mech.block.super_piston')] )),
    default_page('turn_table','ef03',2022,                          createRecipeList( [(1,'block.minecraft.hopper'),(1,'mech.block.super_piston')] )),
    default_page('dimensional_generator','ef06',2015,               createRecipeList( [(2,'block.minecraft.nether_bricks'),(2,'block.minecraft.purpur_block'),(2,'mech.plate.super_conductive'),(1,'mech.ingot.nether_alloy'),(1,'mech.ingot.ender_alloy'),(1,'mech.resource.machine_frame_tier_3')] )),
    upgrades_page('mech.manual.dimensional_generator'),
    blank_page(title=json_text(string='mech.manual.overworld_fuels.title',translate=True,color='dark_aqua'),body=json_text(string='mech.manual.overworld_fuels.body',translate=True)),
    blank_page(title=json_text(string='mech.manual.ender_fuels.title',translate=True,color='dark_aqua'),body=json_text(string='mech.manual.ender_fuels.body',translate=True)),
    blank_page(title=json_text(string='mech.manual.nether_fuels.title',translate=True,color='dark_aqua'),body=json_text(string='mech.manual.nether_fuels.body',translate=True)),
    default_page('lightning_generator','ef09',2030,                 createRecipeList( [(4,'mech.gem.crystal_composite'),(3,'mech.gear.super_conductive'),(1,'mech.plate.nether_alloy'),(1,'mech.resource.machine_frame_tier_3')] )),
    upgrades_page('mech.manual.lightning_generator'),
    default_page('teleporter','ef0c',2017,                          createRecipeList( [(4,'item.minecraft.ender_eye'),(2,'mech.plate.super_conductive'),(1,'mech.gem.crystal_composite'),(1,'mech.gear.ender_alloy'),(1,'mech.resource.machine_frame_tier_3')] )),
    upgrades_page('mech.manual.teleporter'),
    default_page('enchanting_station','ef0f',2016,                  createRecipeList( [(4,'block.minecraft.crying_obsidian'),(2,'mech.gear.super_conductive'),(2,'mech.gem.crystal_composite'),(1,'mech.resource.machine_frame_tier_3')] )),
    upgrades_page('mech.manual.enchanting_station'),
    default_page('spawner_controller','ef12',2019,                  createRecipeList( [(4,'block.minecraft.wither_skeleton_skull'),(2,'mech.rod.super_conductive'),(2,'mech.ingot.nether_alloy'),(1,'mech.resource.machine_frame_tier_3')] )),
    upgrades_page('mech.manual.spawner_controller'),
    default_page('spawner_mover','ef15',2100,                       createRecipeList( [(4,'block.minecraft.iron_bars'),(2,'item.minecraft.shulker_shell'),(2,'mech.ingot.ender_alloy'),(1,'mech.ingot.nether_alloy')] ))
]
write_manual('machines.json',pages)

#nuclear manual
pages = [
    apps_page(),
    index_page('mech.manual.nuclear_section',[
        create_index_icon('\\uee23','nuclear_physics',3),
        create_index_icon('\\uef1c','centrifuge',4),
        create_index_icon('\\uef1d','uranium_fuel_cell',5),
        create_index_icon('\\uef1e','plutonium_fuel_cell',6),
        create_index_icon('\\uef1f','spent_fuel_cell',7),

        create_index_icon('\\uef20','fission_reactor',8),
        create_index_icon('\\uef21','steam_turbine',9),
        create_index_icon('\\uef22','control_rod',10),
        create_index_icon('\\uef23','temperature_observer',11),
        create_index_icon('\\uef24','reaction_rate_observer',12)
    ]),
    blank_page(title=json_text(string='mech.manual.nuclear_physics.title',translate=True,color='dark_aqua'),body=json_text(string='mech.manual.nuclear_physics.body',translate=True,extra=[json_open_webpage('https://github.com/ICY105/Mechanization/wiki/Fission-Reactor')])),
    default_page('centrifuge','ef25',3000,              createRecipeList( [(4,'block.minecraft.red_nether_bricks'),(2,'mech.gear.conductive'),(1,'item.minecraft.bucket'),(1,'item.minecraft.yellow_dye'),(1,'block.minecraft.hopper'),(1,'mech.resource.machine_frame_tier_2')] )),
    default_page('uranium_fuel_cell','ef28',3100,       createRecipeList( [(6,'block.minecraft.glass'),(3,'mech.plate.uranium')] )),
    default_page('plutonium_fuel_cell','ef2b',3101,     createRecipeList( [(6,'block.minecraft.glass'),(3,'mech.plate.plutonium')] )),
    default_page('spent_fuel_cell','ef2e'),
    default_page('fission_reactor','ef2f',3002,         createRecipeList( [(4,'mech.plate.steel'),(2,'mech.gear.uranium'),(2,'block.minecraft.black_stained_glass'),(1,'mech.resource.machine_frame_tier_2')] )),
    default_page('steam_turbine','ef32',3004,           createRecipeList( [(4,'item.minecraft.prismarine_crystals'),(2,'mech.rod.conductive'),(1,'mech.rod.steel'),(1,'item.minecraft.bucket'),(1,'mech.resource.machine_frame_tier_2')] )),
    default_page('control_rod','ef35',3001,             createRecipeList( [(8,'mech.ingot.steel'),(1,'block.minecraft.coal_block')] )),
    default_page('temperature_observer','ef38',3005,    createRecipeList( [(8,'mech.ingot.steel'),(1,'block.minecraft.observer'),(1,'item.minecraft.magma_cream')] )),
    default_page('reaction_rate_observer','ef3b',3003,  createRecipeList( [(8,'mech.ingot.steel'),(1,'block.minecraft.observer'),(1,'item.minecraft.clock')] ))
]
write_manual('nuclear.json',pages)

#gadgets manual
pages = [
    apps_page(),
    index_page('mech.manual.gadgets_section',[
        create_index_icon('\\uef3e','tinker_table',3),
        create_index_icon('\\uef3f','charging_station',4),
        create_index_icon('\\uef40','portable_battery',5),
        create_index_icon('\\uef41','energy_saber',6),
        create_index_icon('\\uef42','drill',9),

        create_index_icon('\\uef43','modular_helmet',12),
        create_index_icon('\\uef44','modular_chestplate',13),
        create_index_icon('\\uef45','modular_leggings',14),
        create_index_icon('\\uef46','modular_boots',15),
        create_index_icon('\\uef47','plasma_weapon',18),

        create_index_icon('\\uef48','rebreather',19),
        create_index_icon('\\uef49','night_vision_goggles',20),
        create_index_icon('\\uef4a','hover_boots',21),
        create_index_icon('\\uef4b','phase_boots',22),
        create_index_icon('\\uef4c','jetpack',23),

        create_index_icon('\\uef4d','energized_heat_sink',24),
        create_index_icon('\\uef4e','supercharged_chamber',25),
        create_index_icon('\\uef4f','high_pressure_pump',26),
        create_index_icon('\\uef50','long_barrel',27),
        create_index_icon('\\uee15','',28),

        create_index_icon('\\uef51','passive_heat_sink',29),
        create_index_icon('\\uef52','overclocked_chamber',30),
        create_index_icon('\\uef53','accelerated_pump',31),
        create_index_icon('\\uef54','split_barrel',32)
    ]),
    default_page('tinker_table','ef55',4001,        createRecipeList( [(3,'block.minecraft.lime_stained_glass'),(2,'item.minecraft.diamond'),(2,'mech.gear.copper'),(1,'mech.ingot.titanium'),(1,'mech.resource.machine_frame_tier_1')] )),
    default_page('charging_station','ef94',4000,    createRecipeList( [(4,'mech.ingot.steel'),(2,'block.minecraft.glass'),(1,'mech.gem.crystal_composite'),(1,'mech.gear.conductive'),(1,'mech.resource.machine_frame_tier_2')] )),
    default_page('portable_battery','ef58',4110,    createRecipeList( [(6,'mech.ingot.tin'),(2,'mech.rod.conductive'),(1,'mech.gear.redstone')] )),
    default_page('energy_saber','ef5b',4100,        createRecipeList( [(2,'mech.rod.copper'),(1,'mech.ingot.titanium'),(1,'mech.gear.iron'),(1,'item.minecraft.diamond')] )),
    blank_page(title=json_text(string='mech.manual.energy_saber_effects.title',translate=True,color='dark_aqua'),body=json_text(string='mech.manual.energy_saber_effects.body1',translate=True)),
    blank_page(body=json_text(string='mech.manual.energy_saber_effects.body2',translate=True)),
    default_page('drill','ef5e',4101,               createRecipeList( [(3,'mech.rod.copper'),(2,'mech.ingot.tin'),(1,'mech.ingot.titanium'),(1,'mech.gear.iron')] )),
    blank_page(title=json_text(string='mech.manual.drill_effects.title',translate=True,color='dark_aqua'),body=json_text(string='mech.manual.drill_effects.body1',translate=True)),
    blank_page(body=json_text(string='mech.manual.drill_effects.body2',translate=True)),
    default_page('modular_helmet','ef61',4106,      createRecipeList( [(2,'mech.gear.copper'),(2,'mech.plate.iron'),(1,'mech.ingot.titanium')] )),
    default_page('modular_chestplate','ef64',4107,  createRecipeList( [(4,'item.minecraft.iron_ingot'),(2,'mech.rod.copper'),(1,'mech.plate.tin'),(1,'mech.ingot.titanium')] )),
    default_page('modular_leggings','ef67',4108,    createRecipeList( [(2,'mech.gear.tin'),(2,'mech.rod.copper'),(2,'mech.plate.iron'),(1,'mech.ingot.titanium')] )),
    default_page('modular_boots','ef6a',4109,       createRecipeList( [(2,'mech.rod.iron'),(2,'mech.plate.tin'),(1,'mech.ingot.titanium')] )),
    blank_page(title=json_text(string='mech.manual.armor_effects.title',translate=True,color='dark_aqua'),body=json_text(string='mech.manual.armor_effects.body1',translate=True)),
    blank_page(body=json_text(string='mech.manual.armor_effects.body2',translate=True)),
    default_page('plasma_weapon','ef6d',4102,       createRecipeList( [(4,'mech.ingot.titanium_steel'),(2,'mech.rod.super_conductive'),(1,'mech.plate.reinforced_structural')] )),
    default_page('rebreather','ef70',4112,          createRecipeList( [(2,'mech.rod.structural'),(2,'mech.plate.steel'),(1,'mech.gear.conductive'),(1,'item.minecraft.turtle_helmet'),(1,'block.minecraft.glass')] )),
    default_page('night_vision_goggles','ef73',4113,createRecipeList( [(2,'mech.rod.conductive'),(2,'mech.plate.steel'),(1,'mech.gear.structural'),(1,'item.minecraft.iron_helmet'),(1,'block.minecraft.lime_stained_glass')] )),
    default_page('hover_boots','ef76',4114,         createRecipeList( [(2,'mech.plate.steel'),(2,'item.minecraft.phantom_membrane'),(1,'mech.gear.conductive'),(1,'mech.gear.structural'),(1,'item.minecraft.iron_boots')] )),
    default_page('phase_boots','ef79',4115,         createRecipeList( [(2,'mech.ingot.ender_alloy'),(2,'mech.rod.reinforced_structural'),(1,'mech.plate.titanium_steel'),(1,'mech.gear.super_conductive'),(1,'item.minecraft.iron_boots')] )),
    default_page('jetpack','ef7c',4111,             createRecipeList( [(2,'mech.plate.titanium_steel'),(2,'mech.rod.super_conductive'),(1,'mech.gear.reinforced_structural'),(1,'item.minecraft.elytra'),(1,'mech.gem.crystal_composite')] )),
    default_page('energized_heat_sink','ef7f',4216, createRecipeList( [(4,'mech.rod.conductive'),(3,'block.minecraft.blue_ice')] )),
    default_page('supercharged_chamber','ef82',4206,createRecipeList( [(4,'block.minecraft.red_stained_glass'),(2,'mech.rod.reinforced_structural'),(2,'mech.ingot.reinforced_structural'),(1,'mech.rod.nether_alloy')] )),
    default_page('high_pressure_pump','ef85',4211,  createRecipeList( [(4,'block.minecraft.red_stained_glass'),(2,'mech.plate.redstone'),(1,'mech.rod.titanium_steel'),(1,'mech.gear.titanium_steel'),(1,'mech.rod.nether_alloy')] )),
    default_page('long_barrel','ef88',4202,         createRecipeList( [(4,'mech.ingot.super_conductive'),(2,'mech.rod.super_conductive'),(1,'mech.gem.crystal_composite')] )),
    default_page('passive_heat_sink','ef97',4216,   createRecipeList( [(4,'mech.rod.conductive'),(3,'block.minecraft.blue_ice')] )),
    default_page('overclocked_chamber','ef8b',4207, createRecipeList( [(4,'block.minecraft.blue_stained_glass'),(2,'mech.rod.reinforced_structural'),(2,'mech.ingot.reinforced_structural'),(1,'mech.rod.ender_alloy')] )),
    default_page('accelerated_pump','ef8e',4212,    createRecipeList( [(4,'block.minecraft.blue_stained_glass'),(2,'mech.plate.redstone'),(1,'mech.rod.titanium_steel'),(1,'mech.gear.titanium_steel'),(1,'mech.rod.ender_alloy')] )),
    default_page('split_barrel','ef91',4201,        createRecipeList( [(3,'mech.rod.super_conductive'),(1,'mech.ingot.super_conductive'),(1,'mech.gem.crystal_composite')] ))
]
write_manual('gadgets.json',pages)

#assembly manual
pages = [
    apps_page(),
    index_page('mech.manual.assembly_section',[
        create_index_icon('\\uef9a','compressor',3),
        create_index_icon('\\uef9b','decompressor',4),
        create_index_icon('\\uef9c','stone_cutter',5),
        create_index_icon('\\uef9d','dye_machine',6),
        create_index_icon('\\uef9e','auto_jukebox',7),

        create_index_icon('\\uef9f','fast_hopper',8),
        create_index_icon('\\uefa0','item_pipe',9),
        create_index_icon('\\uefa1','item_extractor',10),
        create_index_icon('\\uefa2','item_inserter',11),
        create_index_icon('\\uefa3','item_filter',12),
        
        create_index_icon('\\uefa4','ender_hopper',13),
        create_index_icon('\\uefa5','storage_unit',14),
        create_index_icon('\\uefa6','mss_drive_bay',15),
        create_index_icon('\\uefa7','mss_storage_drive',16),
        create_index_icon('\\uefa8','mss_terminal',17)
    ]),
    default_page('compressor','efa9',5000,         createRecipeList( [(4,'block.minecraft.piston'),(2,'mech.plate.conductive'),(1,'block.minecraft.crafting_table'),(1,'block.minecraft.iron_block'),(1,'mech.resource.machine_frame_tier_2')] )),
    default_page('decompressor','efac',5001,       createRecipeList( [(4,'block.minecraft.piston'),(2,'mech.plate.conductive'),(1,'block.minecraft.crafting_table'),(1,'item.minecraft.iron_ingot'),(1,'mech.resource.machine_frame_tier_2')] )),
    default_page('stone_cutter','efaf',5002,       createRecipeList( [(4,'block.minecraft.chiseled_stone_bricks'),(2,'mech.plate.conductive'),(1,'block.minecraft.stonecutter'),(1,'item.minecraft.iron_pickaxe'),(1,'mech.resource.machine_frame_tier_2')] )),
    default_page('dye_machine','efb2',5003,        createRecipeList( [(2,'mech.rod.conductive'),(1,'item.minecraft.red_dye'),(1,'item.minecraft.yellow_dye'),(1,'item.minecraft.blue_dye'),(1,'item.minecraft.white_dye'),(1,'item.minecraft.green_dye'),(1,'item.minecraft.black_dye'),(1,'mech.resource.machine_frame_tier_2')] )),
    default_page('auto_jukebox','efb5',5006,       createRecipeList( [(8,'mech.ingot.steel'),(1,'mech.gem.crystal_composite')] )),
    default_page('fast_hopper','efb8',5005,        createRecipeList( [(4,'mech.ingot.steel'),(2,'item.minecraft.blaze_powder'),(2,'mech.ingot.structural'),(1,'block.minecraft.hopper')] )),
    default_page('item_pipe','efbb',5012,          createRecipeList( [(2,'mech.ingot.steel'),(1,'mech.ingot.structural')] )),
    default_page('item_extractor','efbe',5008,     createRecipeList( [(2,'mech.ingot.steel'),(1,'mech.gem.crystal_composite'),(1,'mech.rod.conductive'),(1,'mech.block.item_pipe')] )),
    default_page('item_inserter','efc1',5009,      createRecipeList( [(2,'mech.ingot.steel'),(1,'mech.gem.crystal_composite'),(1,'mech.rod.structural'),(1,'mech.block.item_pipe')] )),
    default_page('item_filter','efc5',5100,        createRecipeList( [(8,'item.minecraft.string'),(1,'mech.gear.iron')] )),
    default_page('ender_hopper','efc8',5004,       createRecipeList( [(4,'mech.ingot.steel'),(2,'item.minecraft.ender_eye'),(2,'mech.ingot.structural'),(1,'block.minecraft.hopper')] )),
    default_page('storage_unit','efcb',5007,       createRecipeList( [(6,'block.minecraft.chest'),(1,'block.minecraft.ender_chest'),(1,'block.minecraft.hopper'),(1,'mech.resource.machine_frame_tier_2')] )),
    default_page('mss_drive_bay','efce',5011,      createRecipeList( [(4,'block.minecraft.iron_bars'),(2,'mech.gear.conductive'),(1,'mech.gem.crystal_composite'),(1,'block.minecraft.barrel'),(1,'mech.resource.machine_frame_tier_2')] )),
    default_page('mss_storage_drive','efd1',5106,  createRecipeList( [(4,'mech.ingot.titanium_steel'),(2,'mech.rod.super_conductive'),(1,'mech.rod.ender_alloy'),(1,'mech.rod.nether_alloy'),(1,'mech.resource.machine_frame_tier_2')] )),
    default_page('mss_terminal','efd4',5010,       createRecipeList( [(4,'item.minecraft.netherite_ingot'),(1,'mech.plate.ender_alloy'),(1,'mech.plate.nether_alloy'),(1,'mech.gear.super_conductive'),(1,'mech.gear.crystal_composite'),(1,'mech.resource.machine_frame_tier_3')] ))
]
write_manual('assembly.json',pages)


#cleanup
pin_recipe_file.write(pin_recipe_footer)
pin_recipe_file.close()
