#version 150

#moj_import <vsh_util.glsl>

in vec3 Position;
in vec2 UV0;
in vec4 Color;
in vec3 Normal;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;

out float check;
out vec2 texCoord0;
out float vertexDistance;
out vec4 vertexColor;
out vec4 normal;

void main() {
    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);

    texCoord0 = UV0;
    vertexDistance = length((ModelViewMat * vec4(Position, 1.0)).xyz);
    vertexColor = Color;
    normal = ProjMat * ModelViewMat * vec4(Normal, 0.0);
    if (isGUI(ProjMat)) {
        check = float(Normal == vec3(0.0, 109.0/127.0, 63.0/127.0));
    } else {
        check = float(Normal == vec3(0.0, 1.0, 0.0));
    }
}
