# Clear slot-blocking items from players
clear @a black_stained_glass_pane{CustomModelData: 2435000}
clear @a black_stained_glass_pane{onarail: 1b}

# Copy inventory and remove all gui items & any items we want to be there
data modify storage onarail:storage TempItems set from entity @s Items
data remove storage onarail:storage TempItems[{id: "minecraft:black_stained_glass_pane", tag: {CustomModelData: 2435000}}]
data remove storage onarail:storage TempItems[{id: "minecraft:black_stained_glass_pane", tag: {onarail: 1b}}]
data remove storage onarail:storage TempItems[{Slot: 11b}]
data remove storage onarail:storage TempItems[{Slot: 12b}]
data remove storage onarail:storage TempItems[{Slot: 13b}]
data remove storage onarail:storage TempItems[{Slot: 14b}]
data remove storage onarail:storage TempItems[{Slot: 15b}]
execute if data entity @s Items[{Slot: 8b, id: "minecraft:paper"}].tag.display.Name run data remove storage onarail:storage TempItems[{Slot: 8b}]
execute if data entity @s Items[{Slot: 17b, id: "minecraft:paper"}].tag.display.Name run data remove storage onarail:storage TempItems[{Slot: 17b}]
execute if data entity @s Items[{Slot: 26b, id: "minecraft:paper"}].tag.display.Name run data remove storage onarail:storage TempItems[{Slot: 26b}]

# Check for tickets & tag @s
function onarail:gui/ticket_tags
scoreboard players set $success onarail.cart 0

# If there's an item in the 1st slot, try to put it into any available slot
execute if data storage onarail:storage TempItems[{Slot: 0b}] run function onarail:gui/relocate_first_slot

# If there's still items left, we need to clear them
execute if data storage onarail:storage TempItems[] run function onarail:gui/drop_items
function onarail:gui/reset_gui

# Try to move tickets in the fuel slots to any available ticket slots
execute if data entity @s Items[{id: "minecraft:paper", Slot: 11b}].tag.display.Name run function onarail:gui/ticket/import_1
execute if data entity @s Items[{id: "minecraft:paper", Slot: 12b}].tag.display.Name run function onarail:gui/ticket/import_2
execute if data entity @s Items[{id: "minecraft:paper", Slot: 13b}].tag.display.Name run function onarail:gui/ticket/import_3
execute if data entity @s Items[{id: "minecraft:paper", Slot: 14b}].tag.display.Name run function onarail:gui/ticket/import_4
execute if data entity @s Items[{id: "minecraft:paper", Slot: 15b}].tag.display.Name run function onarail:gui/ticket/import_5

# Disable hoppers under furnace minecarts (check all 4 corners)
execute positioned ~.49 ~-1 ~.49 if block ~ ~ ~ hopper if data block ~ ~ ~ Items[{id: "minecraft:black_stained_glass_pane", tag: {CustomModelData: 2435000}}] run function onarail:gui/clear_hopper
execute positioned ~-.49 ~-1 ~.49 if block ~ ~ ~ hopper if data block ~ ~ ~ Items[{id: "minecraft:black_stained_glass_pane", tag: {CustomModelData: 2435000}}] run function onarail:gui/clear_hopper
execute positioned ~.49 ~-1 ~-.49 if block ~ ~ ~ hopper if data block ~ ~ ~ Items[{id: "minecraft:black_stained_glass_pane", tag: {CustomModelData: 2435000}}] run function onarail:gui/clear_hopper
execute positioned ~-.49 ~-1 ~-.49 if block ~ ~ ~ hopper if data block ~ ~ ~ Items[{id: "minecraft:black_stained_glass_pane", tag: {CustomModelData: 2435000}}] run function onarail:gui/clear_hopper
execute as @s[tag=onarail.temp.cleared_hopper] run function onarail:gui/cleared_hopper

# Check if need to consume a fuel
execute if score @s[tag=onarail.stationary] onarail.fuel matches ..0 run function onarail:fuel/consume_fuel
# Check if need to consume a chunk fuel
execute if score @s[tag=onarail.stationary] onarail.chunkFuel matches ..0 run function onarail:chunk_loading/consume_chunk_fuel

# Update the fuel indicator
function onarail:gui/fuel_indicator

# Update the marker with our new data to prevent a 2nd inv change triggering
data modify entity @e[type=marker,tag=onarail.furnace_minecart_data,limit=1,sort=nearest,distance=0...1] data.Items set from entity @s Items