package net.fabricmc.example.mixin;

import net.fabricmc.example.IZombiePigman;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.mob.ZombieEntity;
import net.minecraft.entity.mob.ZombiePigmanEntity;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import java.util.Random;

@Mixin(ZombiePigmanEntity.class)
public abstract class ZombiePigmanMixin extends ZombieEntity implements IZombiePigman
{
	@Shadow
	int anger;
	
	public ZombiePigmanMixin(EntityType<? extends ZombieEntity> entityType_1, World world_1)
	{
		super(entityType_1, world_1);
	}
	
	@Override
	public int getAnger()
	{
		return anger;
	}
	
	@Override
	public void setAnger(int i_anger)
	{
		anger = i_anger;
	}
	
	@Shadow
	public abstract void shadow$copyEntityData(Entity entity_1, int int_1);
	
	public void entityData(Entity entity_1, int int_1)
	{
		shadow$copyEntityData(entity_1, int_1);
	}
	
	@Override
	public Random getRandom()
	{
		return random;
	}
}
