package net.fabricmc.example.mixin;

import net.fabricmc.example.IZombiePigman;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.RevengeGoal;
import net.minecraft.entity.mob.MobEntity;
import net.minecraft.entity.mob.MobEntityWithAi;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(targets = "net/minecraft/entity/mob/ZombiePigmanEntity$AvoidZombiesGoal")
public abstract class ExampleMixin extends RevengeGoal
{
	
	public ExampleMixin(MobEntityWithAi mobEntityWithAi_1, Class<?>... classs_1) // compiler semantics zzz
	{
		super(mobEntityWithAi_1, classs_1);
	}
	
	@Overwrite
	/*@Inject(at = @At("RETURN"), method = "setMobEntityTarget(Lnet/minecraft/entity/mob/MobEntity;" +
			"Lnet/minecraft/entity/LivingEntity;)V")*/
	public void setMobEntityTarget(MobEntity mobEntity_1, LivingEntity livingEntity_1)
	{
		super.setMobEntityTarget(mobEntity_1, livingEntity_1);
		IZombiePigman pigman = (IZombiePigman) mob;
		if (mobEntity_1 instanceof IZombiePigman && pigman.getAnger() > 0) {
			int int_1 = pigman.getAnger();
			if(mob.canSee(livingEntity_1))
			{
				int_1 = pigman.getRandom().nextInt(400)+400;
				System.out.println("setting new anger " + int_1);
			}
			else
			{
				System.out.println("old anger " + int_1);
			}
			((IZombiePigman) mobEntity_1).entityData(livingEntity_1, int_1);
		}
		/*if (mob.canSee(livingEntity_1))
		{
			System.out.println("visible - reset anger to 400+rand(400)");
		}
		else
		{
			System.out.println("invisible - propagate anger level");
		}*/
	}
}
