# --SET SETTINGS--

#  Reset settings if requested
execute if entity @a[scores={reset=1..}] run function minigame:load
scoreboard players reset @a[scores={reset=1..}] reset


#  Start Maps
execute if entity @a[tag=admin,scores={start_map=-1}] run function minigame:maps/random
execute if entity @a[tag=admin,scores={start_map=1}] run function minigame:maps/mesa1_reset
execute if entity @a[tag=admin,scores={start_map=2}] run function minigame:maps/city1_reset
execute if entity @a[tag=admin,scores={start_map=3}] run function minigame:maps/forest1_reset
execute if entity @a[tag=admin,scores={start_map=4}] run function minigame:maps/castle1_reset
#execute if entity @a[tag=admin,scores={start_map=5}] run function minigame:maps/maze1_reset
#execute if entity @a[tag=admin,scores={start_map=6}] run function minigame:maps/refinery1_reset
#execute if entity @a[tag=admin,scores={start_map=7}] run function minigame:maps/?????????1_reset

execute if entity @a[tag=admin,scores={start_map=1..}] run schedule function minigame:game/init 5t
execute if entity @a[tag=admin,scores={start_map=..-1}] run schedule function minigame:game/init 5t

title @a[tag=!admin,scores={start_map=1..}] actionbar {"text":"You are not allowed to change settings"}
title @a[tag=!admin,scores={start_map=..-1}] actionbar {"text":"You are not allowed to change settings"}
scoreboard players reset @a[scores={start_map=1..}] start_map
scoreboard players reset @a[scores={start_map=..-1}] start_map


#  Health
execute as @a[tag=admin,scores={health=1..}] run scoreboard players operation health settings = @s health

title @a[tag=!admin,scores={health=1..}] actionbar {"text":"You are not allowed to change settings"}
scoreboard players reset @a[scores={health=1..}] health

#nr
execute if entity @a[tag=admin,scores={regen=1}] run scoreboard players set regen settings 1
execute if entity @a[tag=admin,scores={regen=-1}] run scoreboard players set regen settings 0

title @a[tag=!admin,scores={regen=1..}] actionbar {"text":"You are not allowed to change settings"}
title @a[tag=!admin,scores={regen=..-1}] actionbar {"text":"You are not allowed to change settings"}
scoreboard players reset @a[scores={regen=1..}] regen
scoreboard players reset @a[scores={regen=..-1}] regen


#  Effects
execute as @a[tag=admin,scores={effect=1}] run scoreboard players set effect settings 1
execute as @a[tag=admin,scores={effect=2}] run scoreboard players set effect settings 2
execute as @a[tag=admin,scores={effect=3}] run scoreboard players set effect settings 3
execute as @a[tag=admin,scores={effect=4}] run scoreboard players set effect settings 4

execute as @a[tag=admin,scores={effect=-1}] run scoreboard players set effect settings 5
execute as @a[tag=admin,scores={effect=-2}] run scoreboard players set effect settings 6
execute as @a[tag=admin,scores={effect=-3}] run scoreboard players set effect settings 7
execute as @a[tag=admin,scores={effect=-4}] run scoreboard players set effect settings 8

execute as @a[tag=admin,scores={effect=-10}] run scoreboard players set effect settings 0

title @a[tag=!admin,scores={effect=1..}] actionbar {"text":"You are not allowed to change settings"}
title @a[tag=!admin,scores={effect=..-1}] actionbar {"text":"You are not allowed to change settings"}
scoreboard players reset @a[scores={effect=1..}] effect
scoreboard players reset @a[scores={effect=..-1}] effect


#  Game Timings
#gl
execute as @a[tag=admin,scores={gameLength=1..}] run scoreboard players operation gameLength settings += @s gameLength
execute as @a[tag=admin,scores={gameLength=..-1}] run scoreboard players operation gameLength settings += @s gameLength

title @a[tag=!admin,scores={gameLength=1..}] actionbar {"text":"You are not allowed to change settings"}
title @a[tag=!admin,scores={gameLength=..-1}] actionbar {"text":"You are not allowed to change settings"}
scoreboard players reset @a[scores={gameLength=1..}] gameLength
scoreboard players reset @a[scores={gameLength=..-1}] gameLength

#pt
execute as @a[tag=admin,scores={prepTime=1..}] run scoreboard players operation prepTime settings += @s prepTime
execute as @a[tag=admin,scores={prepTime=..-1}] run scoreboard players operation prepTime settings += @s prepTime

title @a[tag=!admin,scores={prepTime=1..}] actionbar {"text":"You are not allowed to change settings"}
title @a[tag=!admin,scores={prepTime=..-1}] actionbar {"text":"You are not allowed to change settings"}
scoreboard players reset @a[scores={prepTime=1..}] prepTime
scoreboard players reset @a[scores={prepTime=..-1}] prepTime

#eb
execute as @a[tag=admin,scores={endBossbar=1..}] run scoreboard players operation endBossbar settings += @s endBossbar
execute as @a[tag=admin,scores={endBossbar=..-1}] run scoreboard players operation endBossbar settings += @s endBossbar

title @a[tag=!admin,scores={endBossbar=1..}] actionbar {"text":"You are not allowed to change settings"}
title @a[tag=!admin,scores={endBossbar=..-1}] actionbar {"text":"You are not allowed to change settings"}
scoreboard players reset @a[scores={endBossbar=1..}] endBossbar
scoreboard players reset @a[scores={endBossbar=..-1}] endBossbar


#  Anti-AFK
#io
execute if entity @a[tag=admin,scores={inactiveOn=1}] run scoreboard players set inactiveOn settings 1
execute if entity @a[tag=admin,scores={inactiveOn=-1}] run scoreboard players set inactiveOn settings 0

title @a[tag=!admin,scores={inactiveOn=1..}] actionbar {"text":"You are not allowed to change settings"}
title @a[tag=!admin,scores={inactiveOn=..-1}] actionbar {"text":"You are not allowed to change settings"}
scoreboard players reset @a[scores={inactiveOn=1..}] inactiveOn
scoreboard players reset @a[scores={inactiveOn=..-1}] inactiveOn

#iw
execute as @a[tag=admin,scores={inactiveMessage=1..}] run scoreboard players operation inactiveMessage settings += @s inactiveMessage
execute as @a[tag=admin,scores={inactiveMessage=..-1}] run scoreboard players operation inactiveMessage settings += @s inactiveMessage

title @a[tag=!admin,scores={inactiveMessage=1..}] actionbar {"text":"You are not allowed to change settings"}
title @a[tag=!admin,scores={inactiveMessage=..-1}] actionbar {"text":"You are not allowed to change settings"}
scoreboard players reset @a[scores={inactiveMessage=1..}] inactiveMessage
scoreboard players reset @a[scores={inactiveMessage=..-1}] inactiveMessage

#im
execute as @a[tag=admin,scores={inactiveMax=1..}] run scoreboard players operation inactiveMax settings += @s inactiveMax
execute as @a[tag=admin,scores={inactiveMax=..-1}] run scoreboard players operation inactiveMax settings += @s inactiveMax

title @a[tag=!admin,scores={inactiveMax=1..}] actionbar {"text":"You are not allowed to change settings"}
title @a[tag=!admin,scores={inactiveMax=..-1}] actionbar {"text":"You are not allowed to change settings"}
scoreboard players reset @a[scores={inactiveMax=1..}] inactiveMax
scoreboard players reset @a[scores={inactiveMax=..-1}] inactiveMax


# --VERIFY SETTINGS--
execute if score gameLength settings < 1 constants run scoreboard players set gameLength settings 200
execute if score shortBreakLength settings < 1 constants run scoreboard players set shortBreakLength settings 20
execute if score longBreakInter settings < 0 constants run scoreboard players set longBreakInter settings 0
execute if score longBreakLength settings < 1 constants run scoreboard players set longBreakLength settings 20
execute if score endBossbar settings < 0 constants run scoreboard players set endBossbar settings 0
execute if score endBossbar settings > gameLength settings run scoreboard players operation endBossbar settings = gameLength settings
execute if score specialParticles settings < 0 constants run scoreboard players set specialParticles settings 0
execute if score specialParticles settings > 1 constants run scoreboard players set specialParticles settings 1
execute if score prepTime settings < 0 constants run scoreboard players set prepTime settings 0
execute if score inactiveOn settings < 0 constants run scoreboard players set inactiveOn settings 0
execute if score inactiveOn settings > 1 constants run scoreboard players set inactiveOn settings 1
execute if score inactiveMessage settings < 1 constants run scoreboard players set inactiveMessage settings 60
execute if score inactiveMax settings < 1 constants run scoreboard players set inactiveMax settings 100
execute if score health settings < 1 constants run scoreboard players set inactiveMax settings 1
execute if score regen settings < 0 constants run scoreboard players set regen settings 0
execute if score regen settings > 1 constants run scoreboard players set regen settings 1
execute if score effect settings < 0 constants run scoreboard players set effect settings 0
execute if score effect settings > 8 constants run scoreboard players set effect settings 0


# --DISPLAY SETTINGS--
#  Game Length
scoreboard players operation glSec interface = gameLength settings
scoreboard players operation glSec interface /= 20 constants
scoreboard players operation glMin interface = glSec interface
scoreboard players operation glMin interface /= 60 constants
scoreboard players operation glSec interface %= 60 constants

#  Prep-time
scoreboard players operation ptSec interface = prepTime settings
scoreboard players operation ptSec interface /= 20 constants

#  End bossbar
scoreboard players operation ebSec interface = endBossbar settings
scoreboard players operation ebSec interface /= 20 constants

#  Inactive Message
scoreboard players operation iwSec interface = inactiveMessage settings
scoreboard players operation iwSec interface /= 20 constants

#  Inactive Maximum
scoreboard players operation imSec interface = inactiveMax settings
scoreboard players operation imSec interface /= 20 constants

#  Update the book
data merge block 0 10 -2 {Book:{tag:{display:{Name:"{\"text\":\"You're not supposed to see this\"}"},title:"UI",author:"Sh4p3gamer20 and MCommandguy",resolved:0b,pages:["[{\"text\":\"-Start a map-\",\"color\":\"dark_green\",\"bold\":true},{\"text\":\"\\n\\nRandom\",\"color\":\"dark_purple\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger start_map set -1\"}},{\"text\":\"\\nMesa\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger start_map set 1\"}},{\"text\":\"\\nCity\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger start_map set 2\"}},{\"text\":\"\\nForest\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger start_map set 3\"}},{\"text\":\"\\nCastle\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger start_map set 4\"}},{\"text\":\"\\nIkea\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger start_map set 5\"}},{\"text\":\"\\nRefinery\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger start_map set 6\"}},{\"text\":\"\\n?????????\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger start_map set 7\"}},{\"text\":\"\\n\\n\\nSettings\",\"color\":\"dark_blue\",\"bold\":true,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"2\"}},{\"text\":\"\\nReload maps (dev)\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/setblock 78 6 164 minecraft:redstone_block\"}}]","[{\"text\":\"-All Settings-\",\"color\":\"dark_green\",\"bold\":true},{\"text\":\"\\n\\nQuick Start\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"1\"}},{\"text\":\"\\n\\nTournament\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"9\"}},{\"text\":\"\\n\\nHealth Settings\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"3\"}},{\"text\":\"\\nStarting Effects\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"4\"}},{\"text\":\"\\n\\nGame Timings\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"6\"}},{\"text\":\"\\nAnti-AFK\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"8\"}},{\"text\":\"\\n\\nReset all Settings\",\"color\":\"dark_blue\",\"bold\":true,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger reset set 1\"}}]","[{\"text\":\"-Health Settings-\",\"color\":\"dark_green\",\"bold\":true},{\"text\":\"\\n\\nHealth (hearts): \",\"color\":\"dark_red\",\"bold\":true},{\"score\":{\"name\":\"health\",\"objective\":\"settings\"},\"color\":\"dark_red\",\"bold\":true},{\"text\":\"\\n [1]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger health set 1\"}},{\"text\":\" [5]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger health set 5\"}},{\"text\":\" [10]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger health set 10\"}},{\"text\":\"\\n [15]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger health set 15\"}},{\"text\":\" [20]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger health set 20\"}},{\"text\":\"\\n\\nNatural Regen: \",\"color\":\"dark_red\",\"bold\":true},{\"score\":{\"name\":\"regen\",\"objective\":\"settings\"},\"color\":\"dark_red\",\"bold\":true},{\"text\":\"\\n [On]\",\"color\":\"green\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger regen set 1\"}},{\"text\":\" [Off]\",\"color\":\"red\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger regen set -1\"}},{\"text\":\"\\n\\n\\n\\n\\nSettings\",\"color\":\"dark_blue\",\"bold\":true,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"2\"}}]","[{\"text\":\"-Starting Effects-\",\"color\":\"dark_green\",\"bold\":true},{\"text\":\"\\nOnly one effect can be active at a time\",\"color\":\"red\",\"bold\":false},{\"text\":\"\\n\\nBuffs: \",\"color\":\"dark_red\",\"bold\":true},{\"score\":{\"name\":\"effect\",\"objective\":\"settings\"},\"color\":\"dark_red\",\"bold\":true},{\"text\":\"\\n[0] None\",\"color\":\"dark_purple\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger effect set -10\"}},{\"text\":\"\\n[1] Jump Boost\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger effect set 1\"}},{\"text\":\"\\n[2] Slow Falling\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger effect set 2\"}},{\"text\":\"\\n[3] Haste\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger effect set 3\"}},{\"text\":\"\\n[4] Speed\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger effect set 4\"}},{\"text\":\"\\n\\nNerfs\",\"color\":\"dark_blue\",\"bold\":true,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"5\"}},{\"text\":\"\\nSettings\",\"color\":\"dark_blue\",\"bold\":true,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"2\"}}]","[{\"text\":\"-Starting Effects-\",\"color\":\"dark_green\",\"bold\":true},{\"text\":\"\\nOnly one effect can be active at a time\",\"color\":\"red\",\"bold\":false},{\"text\":\"\\n\\nNerfs: \",\"color\":\"dark_red\",\"bold\":true},{\"score\":{\"name\":\"effect\",\"objective\":\"settings\"},\"color\":\"dark_red\",\"bold\":true},{\"text\":\"\\n[0] None\",\"color\":\"dark_purple\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger effect set -10\"}},{\"text\":\"\\n[5] Blindness\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger effect set -1\"}},{\"text\":\"\\n[6] Nausea\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger effect set -2\"}},{\"text\":\"\\n[7] Mining Fatigue\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger effect set -3\"}},{\"text\":\"\\n[8] Slowness\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger effect set -4\"}},{\"text\":\"\\n\\nBuffs\",\"color\":\"dark_blue\",\"bold\":true,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"4\"}},{\"text\":\"\\nSettings\",\"color\":\"dark_blue\",\"bold\":true,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"2\"}}]","[{\"text\":\"-Game Timings-\",\"color\":\"dark_green\",\"bold\":true},{\"text\":\"\\n\\nGame Length: \",\"color\":\"dark_red\",\"bold\":true},{\"score\":{\"name\":\"glMin\",\"objective\":\"interface\"},\"color\":\"dark_red\",\"bold\":true},{\"text\":\":\",\"color\":\"dark_red\",\"bold\":true},{\"score\":{\"name\":\"glSec\",\"objective\":\"interface\"},\"color\":\"dark_red\",\"bold\":true},{\"text\":\"\\n [-1m]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger gameLength set -1200\"}},{\"text\":\" [-10s]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger gameLength set -200\"}},{\"text\":\"\\n [+10s]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger gameLength set 200\"}},{\"text\":\" [+1m]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger gameLength set 1200\"}},{\"text\":\"\\n\\nPrep-time: \",\"color\":\"dark_red\",\"bold\":true},{\"score\":{\"name\":\"ptSec\",\"objective\":\"interface\"},\"color\":\"dark_red\",\"bold\":true},{\"text\":\"s\",\"color\":\"dark_red\",\"bold\":true},{\"text\":\"\\n [-5s]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger prepTime set -100\"}},{\"text\":\" [-1s]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger prepTime set -20\"}},{\"text\":\"\\n [+1s]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger prepTime set 20\"}},{\"text\":\" [+5s]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger prepTime set 100\"}},{\"text\":\"\\n\\nNext\",\"color\":\"dark_blue\",\"bold\":true,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"7\"}},{\"text\":\"\\n\\nSettings\",\"color\":\"dark_blue\",\"bold\":true,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"2\"}}]","[{\"text\":\"-Game Timings-\",\"color\":\"dark_green\",\"bold\":true},{\"text\":\"\\n\\nEnd-bossbar: \",\"color\":\"dark_red\",\"bold\":true},{\"score\":{\"name\":\"ebSec\",\"objective\":\"interface\"},\"color\":\"dark_red\",\"bold\":true},{\"text\":\"s\",\"color\":\"dark_red\",\"bold\":true},{\"text\":\"\\n [-15s]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger endBossbar set -300\"}},{\"text\":\" [-5s]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger endBossbar set -100\"}},{\"text\":\"\\n [+5s]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger endBossbar set 100\"}},{\"text\":\" [+15s]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger endBossbar set 300\"}},{\"text\":\"\\n\\n\\n\\n\\n\\nPrevious\",\"color\":\"dark_blue\",\"bold\":true,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"6\"}},{\"text\":\"\\n\\nSettings\",\"color\":\"dark_blue\",\"bold\":true,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"2\"}}]","[{\"text\":\"-Anti-AFK-\",\"color\":\"dark_green\",\"bold\":true},{\"text\":\"\\n\\nAnti-AFK: \",\"color\":\"dark_red\",\"bold\":true},{\"score\":{\"name\":\"inactiveOn\",\"objective\":\"settings\"},\"color\":\"dark_red\",\"bold\":true},{\"text\":\"\\n [On]\",\"color\":\"green\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger inactiveOn set 1\"}},{\"text\":\" [Off]\",\"color\":\"red\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger inactiveOn set -1\"}},{\"text\":\"\\n\\nWarning: \",\"color\":\"dark_red\",\"bold\":true},{\"score\":{\"name\":\"iwSec\",\"objective\":\"interface\"},\"color\":\"dark_red\",\"bold\":true},{\"text\":\"s\",\"color\":\"dark_red\",\"bold\":true},{\"text\":\"\\n [-3s]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger inactiveMessage set -60\"}},{\"text\":\" [+3s]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger inactiveMessage set 60\"}},{\"text\":\"\\n\\nMaximum: \",\"color\":\"dark_red\",\"bold\":true},{\"score\":{\"name\":\"imSec\",\"objective\":\"interface\"},\"color\":\"dark_red\",\"bold\":true},{\"text\":\"s\",\"color\":\"dark_red\",\"bold\":true},{\"text\":\"\\n [-5s]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger inactiveMax set -100\"}},{\"text\":\" [+5s]\",\"color\":\"black\",\"bold\":false,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trigger inactiveMax set 100\"}},{\"text\":\"\\n\\nSettings\",\"color\":\"dark_blue\",\"bold\":true,\"clickEvent\":{\"action\":\"change_page\",\"value\":\"2\"}}]"]}}}


# --ENABLE EVERYONE ON SETTINGS
scoreboard players enable @a reset
scoreboard players enable @a start_map
scoreboard players enable @a health
scoreboard players enable @a regen
scoreboard players enable @a effect
scoreboard players enable @a gameLength
scoreboard players enable @a endBossbar
scoreboard players enable @a prepTime
scoreboard players enable @a inactiveOn
scoreboard players enable @a inactiveMessage
scoreboard players enable @a inactiveMax
scoreboard players enable @a shortBreak
scoreboard players enable @a longBreak
scoreboard players enable @a longBreakFreq