#  Miscellaneous
tag @a[team=!,tag=!outOfGame] add inGame
scoreboard players set @a dead 0
scoreboard players set @a left 0
scoreboard players reset @a inactive
scoreboard players set waiting control 0
scoreboard players set break control 0

scoreboard players operation totalLength gamestate = gameLength settings
scoreboard players operation totalLength gamestate += prepTime settings

scoreboard players operation inactiveSeconds gamestate = inactiveMax settings
scoreboard players operation inactiveSeconds gamestate /= 20 constants

#  Prepare players
execute as @a[tag=inGame] run function minigame:game/prep_players

#  Apply settings
execute if score regen settings matches 1 run gamerule naturalRegeneration true
execute if score regen settings matches 0 run gamerule naturalRegeneration false

execute if score effect settings matches 1 run effect give @a[tag=inGame] jump_boost 9999 2 true
execute if score effect settings matches 2 run effect give @a[tag=inGame] slow_falling 9999 0 true
execute if score effect settings matches 3 run effect give @a[tag=inGame] haste 9999 7 true
execute if score effect settings matches 4 run effect give @a[tag=inGame] speed 9999 1 true
execute if score effect settings matches 5 run effect give @a[tag=inGame] blindness 9999 0 true
execute if score effect settings matches 6 run effect give @a[tag=inGame] nausea 9999 1 true
execute if score effect settings matches 7 run effect give @a[tag=inGame] mining_fatigue 9999 2 true
execute if score effect settings matches 8 run effect give @a[tag=inGame] slowness 9999 1 true

#  Bossbar and Timers
scoreboard players set gametick gamestate 0
bossbar set minecraft:bossbar visible true

#  Set Sidebar
function minigame:game/update_scoreboard
scoreboard objectives setdisplay sidebar remainingPlayers

#  Title
execute unless score freeForAll gamestate matches 1 run title @s title {"text":"Team Deathmatch!"}
execute unless score freeForAll gamestate matches 1 run title @s subtitle {"text":"Kill all opposing teams to win."}

execute if score freeForAll gamestate matches 1 run title @s title {"text":"Free-for-All!"}
execute if score freeForAll gamestate matches 1 run title @s subtitle {"text":"Kill all other players to win."}

#  Random spawn
scoreboard players set @e[type=item_frame,nbt={Item:{id:"minecraft:player_head"}}] spawn 0
scoreboard players set @e[x=-33,y=0,z=-115,dx=65,dy=255,dz=97,type=item_frame,nbt={Item:{id:"minecraft:player_head"}},limit=1,sort=random,scores={spawn=0}] spawn 1
scoreboard players set @e[x=-33,y=0,z=-115,dx=65,dy=255,dz=97,type=item_frame,nbt={Item:{id:"minecraft:player_head"}},limit=1,sort=random,scores={spawn=0}] spawn 2
scoreboard players set @e[x=-33,y=0,z=-115,dx=65,dy=255,dz=97,type=item_frame,nbt={Item:{id:"minecraft:player_head"}},limit=1,sort=random,scores={spawn=0}] spawn 3
scoreboard players set @e[x=-33,y=0,z=-115,dx=65,dy=255,dz=97,type=item_frame,nbt={Item:{id:"minecraft:player_head"}},limit=1,sort=random,scores={spawn=0}] spawn 4
scoreboard players set @e[x=-33,y=0,z=-115,dx=65,dy=255,dz=97,type=item_frame,nbt={Item:{id:"minecraft:player_head"}},limit=1,sort=random,scores={spawn=0}] spawn 5
scoreboard players set @e[x=-33,y=0,z=-115,dx=65,dy=255,dz=97,type=item_frame,nbt={Item:{id:"minecraft:player_head"}},limit=1,sort=random,scores={spawn=0}] spawn 6
scoreboard players set @e[x=-33,y=0,z=-115,dx=65,dy=255,dz=97,type=item_frame,nbt={Item:{id:"minecraft:player_head"}},limit=1,sort=random,scores={spawn=0}] spawn 7
scoreboard players set @e[x=-33,y=0,z=-115,dx=65,dy=255,dz=97,type=item_frame,nbt={Item:{id:"minecraft:player_head"}},limit=1,sort=random,scores={spawn=0}] spawn 8

tp @a[team=red,tag=inGame] @e[type=item_frame,scores={spawn=1},limit=1]
tp @a[team=blue,tag=inGame] @e[type=item_frame,scores={spawn=2},limit=1]
tp @a[team=green,tag=inGame] @e[type=item_frame,scores={spawn=3},limit=1]
tp @a[team=yellow,tag=inGame] @e[type=item_frame,scores={spawn=4},limit=1]
tp @a[team=gold,tag=inGame] @e[type=item_frame,scores={spawn=5},limit=1]
tp @a[team=purple,tag=inGame] @e[type=item_frame,scores={spawn=6},limit=1]
tp @a[team=gray,tag=inGame] @e[type=item_frame,scores={spawn=7},limit=1]
tp @a[team=cyan,tag=inGame] @e[type=item_frame,scores={spawn=8},limit=1]

execute as @a[tag=inGame] at @s run tp @s ~ ~ ~ facing 0 20 -66

kill @e[x=-33,y=0,z=-115,dx=65,dy=255,dz=97,type=minecraft:item_frame,nbt={Item:{id:"minecraft:player_head"}}]

#  Activate main loop
scoreboard players set game control 1


#  REMOVE BEFORE FLIGHT
scoreboard objectives setdisplay sidebar.team.red
say GAME STARTED