#version 120

uniform sampler2D DiffuseSampler;

varying vec2 texCoord;
varying vec2 oneTexel;

uniform vec2 InSize;

uniform vec2 BlurDir;
uniform float Radius;

void main() {
    vec4 blurred = vec4(0.0);
    float totalStrength = 0.0;
    for(float r = -Radius; r <= Radius; r += 1.0) {
        vec4 sample = texture2D(DiffuseSampler, texCoord + oneTexel * r * BlurDir);
        float strength = (1.0 - abs(r / Radius)) * sample.a;
        totalStrength = totalStrength + strength;
        blurred = blurred + sample * strength;
    }
    gl_FragColor = vec4(blurred.rgb / totalStrength, (blurred.a * Radius) / totalStrength);
}
