/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
implements ac,
Runnable,
sz {
    private static final Logger i = LogManager.getLogger();
    public static final File a = new File("usercache.json");
    private static MinecraftServer j;
    private final bhr k;
    private final sx l = new sx("server", this, MinecraftServer.as());
    private final File m;
    private final List n = Lists.newArrayList();
    private final ab o;
    public final rt b = new rt();
    private final on p;
    private final lk q = new lk();
    private final Random r = new Random();
    private int t = -1;
    public oe[] c;
    private ps u;
    private boolean v = true;
    private boolean w;
    private int x;
    protected final Proxy d;
    public String e;
    public int f;
    private boolean y;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private String D;
    private int E;
    private int F = 0;
    public final long[] g = new long[100];
    public long[][] h;
    private KeyPair G;
    private String H;
    private String I;
    private String J;
    private boolean K;
    private boolean L;
    private boolean M;
    private String N = "";
    private boolean O;
    private long P;
    private String Q;
    private boolean R;
    private boolean S;
    private final YggdrasilAuthenticationService T;
    private final MinecraftSessionService U;
    private long V = 0L;
    private final GameProfileRepository W;
    private final pd X = new pd(this, a);

    public MinecraftServer(File file, Proxy proxy) {
        j = this;
        this.d = proxy;
        this.m = file;
        this.p = new on(this);
        this.o = new cd();
        this.k = new bha(file);
        this.T = new YggdrasilAuthenticationService(proxy, UUID.randomUUID().toString());
        this.U = this.T.createMinecraftSessionService();
        this.W = this.T.createProfileRepository();
    }

    protected abstract boolean g();

    protected void a(String string) {
        if (this.T().b(string)) {
            i.info("Converting map!");
            this.b("menu.convertingLevel");
            this.T().a(string, new ms(this));
        }
    }

    protected synchronized void b(String string) {
        this.Q = string;
    }

    public synchronized String h() {
        return this.Q;
    }

    protected void a(String string, String string2, long l2, ali ali2, String string3) {
        alf alf2;
        this.a(string);
        this.b("menu.loadingLevel");
        this.c = new oe[3];
        this.h = new long[this.c.length][100];
        bhp bhp2 = this.k.a(string, true);
        this.a(this.P(), bhp2);
        bhf bhf2 = bhp2.d();
        if (bhf2 == null) {
            if (this.S()) {
                alf2 = nu.a;
            } else {
                alf2 = new alf(l2, this.k(), this.j(), this.m(), ali2);
                alf2.a(string3);
                if (this.L) {
                    alf2.a();
                }
            }
            bhf2 = new bhf(alf2, string2);
        } else {
            bhf2.a(string2);
            alf2 = new alf(bhf2);
        }
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            int n2 = 0;
            if (i2 == 1) {
                n2 = -1;
            }
            if (i2 == 2) {
                n2 = 1;
            }
            if (i2 == 0) {
                this.c[i2] = this.S() ? (oe)new nu(this, bhp2, bhf2, n2, this.b).b() : (oe)new oe(this, bhp2, bhf2, n2, this.b).b();
                this.c[i2].a(alf2);
            } else {
                this.c[i2] = (oe)new nw(this, bhp2, n2, this.c[0], this.b).b();
            }
            this.c[i2].a(new oa(this, this.c[i2]));
            if (this.O()) continue;
            this.c[i2].O().a(this.k());
        }
        this.u.a(this.c);
        this.a(this.l());
        this.i();
    }

    protected void i() {
        int n2 = 16;
        int n3 = 4;
        int n4 = 192;
        int n5 = 625;
        int n6 = 0;
        this.b("menu.generatingTerrain");
        int n7 = 0;
        i.info("Preparing start region for level " + n7);
        oe oe2 = this.c[n7];
        df df2 = oe2.L();
        long l2 = MinecraftServer.as();
        for (int i2 = -192; i2 <= 192 && this.r(); i2 += 16) {
            for (int i3 = -192; i3 <= 192 && this.r(); i3 += 16) {
                long l3 = MinecraftServer.as();
                if (l3 - l2 > 1000L) {
                    this.a_("Preparing spawn area", n6 * 100 / 625);
                    l2 = l3;
                }
                ++n6;
                oe2.b.c(df2.n() + i2 >> 4, df2.p() + i3 >> 4);
            }
        }
        this.o();
    }

    protected void a(String string, bhp bhp2) {
        File file = new File(bhp2.b(), "resources.zip");
        if (file.isFile()) {
            this.m("level://" + string + "/" + file.getName());
        }
    }

    public abstract boolean j();

    public abstract alg k();

    public abstract sm l();

    public abstract boolean m();

    public abstract int n();

    protected void a_(String string, int n2) {
        this.e = string;
        this.f = n2;
        i.info(string + ": " + n2 + "%");
    }

    protected void o() {
        this.e = null;
        this.f = 0;
    }

    protected void a(boolean bl2) {
        if (this.M) {
            return;
        }
        for (oe oe2 : this.c) {
            if (oe2 == null) continue;
            if (!bl2) {
                i.info("Saving chunks for level '" + oe2.O().k() + "'/" + oe2.s.l());
            }
            try {
                oe2.a(true, null);
            }
            catch (ald ald2) {
                i.warn(ald2.getMessage());
            }
        }
    }

    public void p() {
        if (this.M) {
            return;
        }
        i.info("Stopping server");
        if (this.aj() != null) {
            this.aj().b();
        }
        if (this.u != null) {
            i.info("Saving players");
            this.u.k();
            this.u.v();
        }
        if (this.c != null) {
            i.info("Saving worlds");
            this.a(false);
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                oe oe2 = this.c[i2];
                oe2.o();
            }
        }
        if (this.l.d()) {
            this.l.e();
        }
    }

    public boolean r() {
        return this.v;
    }

    public void s() {
        this.v = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.g()) {
                long l2 = MinecraftServer.as();
                long l3 = 0L;
                this.q.a(new gr(this.D));
                this.q.a(new lo("14w18a", 16));
                this.a(this.q);
                while (this.v) {
                    long l4 = MinecraftServer.as();
                    long l5 = l4 - l2;
                    if (l5 > 2000L && l2 - this.P >= 15000L) {
                        i.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", new Object[]{l5, l5 / 50L});
                        l5 = 2000L;
                        this.P = l2;
                    }
                    if (l5 < 0L) {
                        i.warn("Time ran backwards! Did the system time change?");
                        l5 = 0L;
                    }
                    l3 += l5;
                    l2 = l4;
                    if (this.c[0].f()) {
                        this.v();
                        l3 = 0L;
                    } else {
                        while (l3 > 50L) {
                            l3 -= 50L;
                            this.v();
                        }
                    }
                    Thread.sleep(Math.max(1L, 50L - l3));
                    this.O = true;
                }
            } else {
                this.a((b)null);
            }
        }
        catch (Throwable throwable) {
            i.error("Encountered an unexpected exception", throwable);
            b b2 = null;
            b2 = throwable instanceof s ? this.b(((s)throwable).a()) : this.b(new b("Exception in server tick loop", throwable));
            File file = new File(new File(this.t(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (b2.a(file)) {
                i.error("This crash report has been saved to: " + file.getAbsolutePath());
            } else {
                i.error("We were unable to save this crash report to disk.");
            }
            this.a(b2);
        }
        finally {
            try {
                this.p();
                this.w = true;
            }
            catch (Throwable throwable) {
                i.error("Exception stopping the server", throwable);
            }
            finally {
                this.u();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(lk lk2) {
        File file = this.d("server-icon.png");
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuf byteBuf2 = Base64.encode((ByteBuf)byteBuf);
                lk2.a("data:image/png;base64," + byteBuf2.toString(Charsets.UTF_8));
            }
            catch (Exception exception) {
                i.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    protected File t() {
        return new File(".");
    }

    protected void a(b b2) {
    }

    protected void u() {
    }

    public void v() {
        long l2 = System.nanoTime();
        ++this.x;
        if (this.R) {
            this.R = false;
            this.b.a = true;
            this.b.a();
        }
        this.b.a("root");
        this.w();
        if (l2 - this.V >= 5000000000L) {
            this.V = l2;
            this.q.a(new ll(this.E(), this.D()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.D(), 12)];
            int n2 = rs.a(this.r, 0, this.D() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = ((oh)this.u.e.get(n2 + i2)).bO();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.q.b().a(gameProfileArray);
        }
        if (this.x % 900 == 0) {
            this.b.a("save");
            this.u.k();
            this.a(true);
            this.b.b();
        }
        this.b.a("tallying");
        this.g[this.x % 100] = System.nanoTime() - l2;
        this.b.b();
        this.b.a("snooper");
        if (!this.l.d() && this.x > 100) {
            this.l.a();
        }
        if (this.x % 6000 == 0) {
            this.l.b();
        }
        this.b.b();
        this.b.b();
    }

    public void w() {
        int n2;
        this.b.a("levels");
        for (n2 = 0; n2 < this.c.length; ++n2) {
            long l2 = System.nanoTime();
            if (n2 == 0 || this.x()) {
                oe oe2 = this.c[n2];
                this.b.a(oe2.O().k());
                if (this.x % 20 == 0) {
                    this.b.a("timeSync");
                    this.u.a(new jo(oe2.J(), oe2.K(), oe2.P().b("doDaylightCycle")), oe2.s.r());
                    this.b.b();
                }
                this.b.a("tick");
                try {
                    oe2.c();
                }
                catch (Throwable throwable) {
                    b b2 = b.a(throwable, "Exception ticking world");
                    oe2.a(b2);
                    throw new s(b2);
                }
                try {
                    oe2.i();
                }
                catch (Throwable throwable) {
                    b b3 = b.a(throwable, "Exception ticking world entities");
                    oe2.a(b3);
                    throw new s(b3);
                }
                this.b.b();
                this.b.a("tracker");
                oe2.s().a();
                this.b.b();
                this.b.b();
            }
            this.h[n2][this.x % 100] = System.nanoTime() - l2;
        }
        this.b.c("connection");
        this.aj().c();
        this.b.c("players");
        this.u.e();
        this.b.c("tickables");
        for (n2 = 0; n2 < this.n.size(); ++n2) {
            ((nb)this.n.get(n2)).a();
        }
        this.b.b();
    }

    public boolean x() {
        return true;
    }

    public void y() {
        new mu(this, "Server thread").start();
    }

    public File d(String string) {
        return new File(this.t(), string);
    }

    public void f(String string) {
        i.warn(string);
    }

    public oe a(int n2) {
        if (n2 == -1) {
            return this.c[1];
        }
        if (n2 == 1) {
            return this.c[2];
        }
        return this.c[0];
    }

    public String C() {
        return "14w18a";
    }

    public int D() {
        return this.u.p();
    }

    public int E() {
        return this.u.q();
    }

    public String[] F() {
        return this.u.g();
    }

    public GameProfile[] G() {
        return this.u.h();
    }

    public String getServerModName() {
        return "vanilla";
    }

    public b b(b b2) {
        b2.g().a("Profiler Position", new mv(this));
        if (this.u != null) {
            b2.g().a("Player Count", new mw(this));
        }
        return b2;
    }

    public List a(ac ac2, String string) {
        ArrayList arrayList = Lists.newArrayList();
        if (string.startsWith("/")) {
            boolean bl2 = !(string = string.substring(1)).contains(" ");
            List list = this.o.b(ac2, string);
            if (list != null) {
                for (String string2 : list) {
                    if (bl2) {
                        arrayList.add("/" + string2);
                        continue;
                    }
                    arrayList.add(string2);
                }
            }
            return arrayList;
        }
        String[] stringArray = string.split(" ", -1);
        String string3 = stringArray[stringArray.length - 1];
        for (String string4 : this.u.g()) {
            if (!x.a(string3, string4)) continue;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public static MinecraftServer J() {
        return j;
    }

    @Override
    public String b_() {
        return "Server";
    }

    @Override
    public void a(gj gj2) {
        i.info(gj2.c());
    }

    @Override
    public boolean a(int n2, String string) {
        return true;
    }

    public ab K() {
        return this.o;
    }

    public KeyPair L() {
        return this.G;
    }

    public String N() {
        return this.H;
    }

    public void j(String string) {
        this.H = string;
    }

    public boolean O() {
        return this.H != null;
    }

    public String P() {
        return this.I;
    }

    public void k(String string) {
        this.I = string;
    }

    public void l(String string) {
        this.J = string;
    }

    public String Q() {
        return this.J;
    }

    public void a(KeyPair keyPair) {
        this.G = keyPair;
    }

    public void a(sm sm2) {
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            oe oe2 = this.c[i2];
            if (oe2 == null) continue;
            if (oe2.O().t()) {
                oe2.O().a(sm.d);
                oe2.a(true, true);
                continue;
            }
            if (this.O()) {
                oe2.O().a(sm2);
                oe2.a(oe2.aa() != sm.a, true);
                continue;
            }
            oe2.O().a(sm2);
            oe2.a(this.R(), this.z);
        }
    }

    protected boolean R() {
        return true;
    }

    public boolean S() {
        return this.K;
    }

    public void b(boolean bl2) {
        this.K = bl2;
    }

    public void c(boolean bl2) {
        this.L = bl2;
    }

    public bhr T() {
        return this.k;
    }

    public void V() {
        this.M = true;
        this.T().d();
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            oe oe2 = this.c[i2];
            if (oe2 == null) continue;
            oe2.o();
        }
        this.T().e(this.c[0].N().g());
        this.s();
    }

    public String W() {
        return this.N;
    }

    public void m(String string) {
        this.N = string;
    }

    @Override
    public void a(sx sx2) {
        sx2.a("whitelist_enabled", false);
        sx2.a("whitelist_count", 0);
        sx2.a("players_current", this.D());
        sx2.a("players_max", this.E());
        sx2.a("players_seen", this.u.r().length);
        sx2.a("uses_auth", this.y);
        sx2.a("gui_state", this.al() ? "enabled" : "disabled");
        sx2.a("run_time", (MinecraftServer.as() - sx2.g()) / 60L * 1000L);
        sx2.a("avg_tick_ms", (int)(rs.a(this.g) * 1.0E-6));
        int n2 = 0;
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            if (this.c[i2] == null) continue;
            oe oe2 = this.c[i2];
            bhf bhf2 = oe2.O();
            sx2.a("world[" + n2 + "][dimension]", oe2.s.r());
            sx2.a("world[" + n2 + "][mode]", (Object)bhf2.r());
            sx2.a("world[" + n2 + "][difficulty]", (Object)oe2.aa());
            sx2.a("world[" + n2 + "][hardcore]", bhf2.t());
            sx2.a("world[" + n2 + "][generator_name]", bhf2.u().a());
            sx2.a("world[" + n2 + "][generator_version]", bhf2.u().d());
            sx2.a("world[" + n2 + "][height]", this.E);
            sx2.a("world[" + n2 + "][chunks_loaded]", oe2.M().g());
            ++n2;
        }
        sx2.a("worlds", n2);
    }

    @Override
    public void b(sx sx2) {
        sx2.b("singleplayer", this.O());
        sx2.b("server_brand", this.getServerModName());
        sx2.b("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        sx2.b("dedicated", this.Y());
    }

    @Override
    public boolean X() {
        return true;
    }

    public abstract boolean Y();

    public boolean Z() {
        return this.y;
    }

    public void d(boolean bl2) {
        this.y = bl2;
    }

    public boolean aa() {
        return this.z;
    }

    public void e(boolean bl2) {
        this.z = bl2;
    }

    public boolean ab() {
        return this.A;
    }

    public void f(boolean bl2) {
        this.A = bl2;
    }

    public boolean ac() {
        return this.B;
    }

    public void g(boolean bl2) {
        this.B = bl2;
    }

    public boolean ad() {
        return this.C;
    }

    public void h(boolean bl2) {
        this.C = bl2;
    }

    public abstract boolean ae();

    public String af() {
        return this.D;
    }

    public void n(String string) {
        this.D = string;
    }

    public int ag() {
        return this.E;
    }

    public void c(int n2) {
        this.E = n2;
    }

    public ps ai() {
        return this.u;
    }

    public void a(ps ps2) {
        this.u = ps2;
    }

    public void a(alg alg2) {
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            MinecraftServer.J().c[i2].O().a(alg2);
        }
    }

    public on aj() {
        return this.p;
    }

    public boolean ak() {
        return this.O;
    }

    public boolean al() {
        return false;
    }

    public abstract String a(alg var1, boolean var2);

    public int am() {
        return this.x;
    }

    public void an() {
        this.R = true;
    }

    public sx ao() {
        return this.l;
    }

    @Override
    public df d_() {
        return df.a;
    }

    @Override
    public aky d() {
        return this.c[0];
    }

    @Override
    public tp f_() {
        return null;
    }

    public int ap() {
        return 16;
    }

    public boolean a(aky aky2, df df2, acc acc2) {
        return false;
    }

    public boolean aq() {
        return this.S;
    }

    public Proxy ar() {
        return this.d;
    }

    public static long as() {
        return System.currentTimeMillis();
    }

    public int at() {
        return this.F;
    }

    public void d(int n2) {
        this.F = n2;
    }

    @Override
    public gj c_() {
        return new gr(this.b_());
    }

    public boolean au() {
        return true;
    }

    public MinecraftSessionService aw() {
        return this.U;
    }

    public GameProfileRepository ax() {
        return this.W;
    }

    public pd ay() {
        return this.X;
    }

    public lk az() {
        return this.q;
    }

    public void aA() {
        this.V = 0L;
    }

    public tp a(UUID uUID) {
        for (oe oe2 : this.c) {
            tp tp2;
            if (oe2 == null || (tp2 = oe2.a(uUID)) == null) continue;
            return tp2;
        }
        return null;
    }

    @Override
    public boolean f() {
        return true;
    }

    public int aB() {
        return 29999984;
    }

    public static /* synthetic */ Logger aC() {
        return i;
    }

    public static /* synthetic */ ps a(MinecraftServer minecraftServer) {
        return minecraftServer.u;
    }
}

