# This tries to prevent players dying from fall-damage when they first enter the Backrooms.
execute as @a at @s if entity @s[y=-65,dy=-2000] run tag @s add EnterBR
execute as @a[tag=EnterBR] at @s in nik_br:backrooms run tp @s ~ 20 ~
execute as @a[tag=EnterBR] run effect give @s minecraft:slow_falling 10 0 true
execute as @a[tag=EnterBR] run tag @s remove EnterBR

# Rarely, a player will spawn in above the top of the map, this tries to correct that.
execute as @a[nbt={Dimension:"nik_br:backrooms"},gamemode=!spectator,gamemode=!creative] at @s if entity @s[y=60,dy=68] run tp @s ~ 20 ~
# Sometimes a player will spawn in walls, or an area without backrooms, this tries to move them till they're in an open hallway.
execute as @a[nbt={Dimension:"nik_br:backrooms"},gamemode=!spectator] at @s if block ~ ~ ~ minecraft:quartz_pillar run tp @s ~4 ~ ~

# Removes hay_block items near players in backrooms, to prevent harvesting/eating the carpet lol.
execute as @a[nbt={Dimension:"nik_br:backrooms"}] at @s in nik_br:backrooms run kill @e[type=item,nbt={Item:{id:"minecraft:hay_block"}},distance=..10]

# Plays a constant buzzing sound for the fluorescent lights.
execute as @a[nbt={Dimension:"nik_br:backrooms"}] at @s in nik_br:backrooms run playsound entity.bee.pollinate ambient @s ~ 24 ~ 0.32 0.8

# Keeps correctly generated exit-doors alive, letting mis-generated ones expire.
execute as @e[type=falling_block,tag=noclip] at @s if block ~ 22 ~ stripped_birch_wood run data merge entity @s {Time:1}

# This section makes the flickering lights work.
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ air run setblock ~ ~-1 ~ light[level=0]
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=1] run setblock ~ ~-1 ~ light[level=0]
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=2] run setblock ~ ~-1 ~ light[level=1]
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=3] run setblock ~ ~-1 ~ light[level=2]
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=4] run setblock ~ ~-1 ~ light[level=3]
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=5] run setblock ~ ~-1 ~ light[level=4]
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=6] run setblock ~ ~-1 ~ light[level=5]
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=7] run setblock ~ ~-1 ~ light[level=6]
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=8] run setblock ~ ~-1 ~ light[level=7]
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=9] run setblock ~ ~-1 ~ light[level=8]
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=10] run setblock ~ ~-1 ~ light[level=9]
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=11] run setblock ~ ~-1 ~ light[level=10]
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=12] run setblock ~ ~-1 ~ light[level=11]
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=13] run setblock ~ ~-1 ~ light[level=12]
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=14] run setblock ~ ~-1 ~ light[level=13]
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=15] run setblock ~ ~-1 ~ light[level=14]
# randomly decides when to flicker, sometimes with a double flash.
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=11] if predicate nik_br:flicker_r run setblock ~ ~-1 ~ light[level=15]
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=0] if predicate nik_br:flicker_r run setblock ~ ~-1 ~ light[level=15]
# plays a couple notes which together sorta sound like a fluorescent bulb flickering.
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=15] in nik_br:backrooms run playsound minecraft:block.note_block.bell ambient @a[nbt={Dimension:"nik_br:backrooms"}] ~ ~ ~ 0.2 1.4
execute as @e[type=marker,tag=flicker] at @s if block ~ ~-1 ~ light[level=15] in nik_br:backrooms run playsound minecraft:block.note_block.snare ambient @a[nbt={Dimension:"nik_br:backrooms"}] ~ ~ ~ 0.2 1.6
# removes the invisible light block and marker entity, if the bone_block no longer exists.
execute as @e[type=marker,tag=flicker] at @s unless block ~ ~ ~ bone_block[axis=y] run setblock ~ ~-1 ~ air
execute as @e[type=marker,tag=flicker] at @s unless block ~ ~ ~ bone_block[axis=y] run kill @s
