#version 150

in vec3 Position;
in vec2 UV0;

uniform sampler2D Sampler0;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform vec2 ScreenSize;

out vec2 texCoord0;


void main() {
    texCoord0 = UV0;
    
    vec4 testColor = floor(texelFetch(Sampler0, ivec2(255), 0) * 255);

    const vec2[4] corners = vec2[4](vec2(0, 0), vec2(0, 1), vec2(1, 1), vec2(1, 0));
    int id = (gl_VertexID + 1) % 4;
    vec2 corner = corners[id];

    ivec2 texSize = textureSize(Sampler0, 0);
    vec2 uv = floor(UV0 * 256);
    vec3 Pos = Position;
    vec2 ScrSize = 2 / vec2(ProjMat[0][0], -ProjMat[1][1]);

    if (testColor == vec4(255, 0, 0, 255)) // // Icons
    {
        if (uv.x >= 16 && uv.x <= 196 && uv.y - corner.y * 9 == 0) //Hearts
        {
            int slotID = int(Pos.x - ScrSize.x / 2 + 92) / 8 - int(corner.x);

            Pos.x -= slotID * 2;
            Pos.z += slotID * 10;
        }
    }

    gl_Position = ProjMat * ModelViewMat * vec4(Pos, 1.0);
}
